/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.test;

import cn.hutool.json.JSONUtil;
import icu.easyj.spring.boot.test.MockResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class MockRequest {
    private final MockMvc mockMvc;
    private final MockHttpServletRequestBuilder builder;

    public MockRequest(MockMvc mockMvc, MockHttpServletRequestBuilder builder) {
        Assert.notNull((Object)mockMvc, (String)"'mockMvc' must be not null");
        Assert.notNull((Object)builder, (String)"'builder' must be not null");
        this.mockMvc = mockMvc;
        this.builder = builder;
        this.init();
    }

    protected void init() {
        this.contentType(MediaType.APPLICATION_JSON);
        this.characterEncoding(StandardCharsets.UTF_8);
    }

    public MockRequest contentType(MediaType contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.builder.contentType(contentType);
        return this;
    }

    public MockRequest contentType(String contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.builder.contentType(contentType);
        return this;
    }

    public MockRequest characterEncoding(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        this.builder.characterEncoding(charset.name());
        return this;
    }

    public MockRequest characterEncoding(String charsetEncoding) {
        Assert.notNull((Object)charsetEncoding, (String)"'encoding' must not be null");
        this.builder.characterEncoding(charsetEncoding);
        return this;
    }

    public MockRequest content(byte[] content) {
        this.builder.content(content);
        return this;
    }

    public MockRequest content(String content) {
        this.builder.content(content);
        this.characterEncoding(StandardCharsets.UTF_8);
        return this;
    }

    public MockRequest content(Object content) {
        String contentJson = JSONUtil.toJsonStr((Object)content);
        this.content(contentJson);
        this.contentType(MediaType.APPLICATION_JSON);
        return this;
    }

    public MockRequest queryParam(String name, String ... values) {
        this.builder.queryParam(name, values);
        return this;
    }

    public MockRequest queryParams(MultiValueMap<String, String> params) {
        this.builder.queryParams(params);
        return this;
    }

    public MockResponse send() throws Exception {
        ResultActions resultActions = this.mockMvc.perform((RequestBuilder)this.builder);
        return new MockResponse(resultActions);
    }
}

