/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.test;

import cn.hutool.json.JSONUtil;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.ResourceUtils;
import icu.easyj.spring.boot.test.MockResponse;
import icu.easyj.test.exception.TestException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class MockRequest {
    protected final String urlTemplate;
    protected final Object[] uriVars;
    protected final MockMvc mockMvc;
    protected MockHttpServletRequestBuilder builder;
    protected MockMultipartHttpServletRequestBuilder multipartBuilder;
    private final Map<String, Object> contentMap = new HashMap<String, Object>();

    public MockRequest(MockMvc mockMvc, MockHttpServletRequestBuilder builder, String urlTemplate, Object[] uriVars) {
        Assert.notNull((Object)mockMvc, (String)"'mockMvc' must be not null");
        Assert.notNull((Object)builder, (String)"'builder' must be not null");
        this.urlTemplate = urlTemplate;
        this.uriVars = uriVars;
        this.mockMvc = mockMvc;
        this.builder = builder;
        this.multipartBuilder = builder instanceof MockMultipartHttpServletRequestBuilder ? (MockMultipartHttpServletRequestBuilder)builder : null;
    }

    public MockRequest header(String name, Object ... values) {
        this.builder.header(name, values);
        return this;
    }

    public MockRequest contentType(MediaType contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.builder.contentType(contentType);
        return this;
    }

    public MockRequest contentType(String contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.builder.contentType(contentType);
        return this;
    }

    public MockRequest characterEncoding(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        this.builder.characterEncoding(charset.name());
        return this;
    }

    public MockRequest characterEncoding(String charsetEncoding) {
        Assert.notNull((Object)charsetEncoding, (String)"'encoding' must not be null");
        this.builder.characterEncoding(charsetEncoding);
        return this;
    }

    public MockRequest content(byte[] content) {
        if (!this.contentMap.isEmpty()) {
            throw new RuntimeException("`MockRequest.content(byte[] content)`\u4e0e`MockRequest.content(String, Object)`\u4e24\u4e2a\u65b9\u6cd5\u4e0d\u80fd\u6df7\u5408\u4f7f\u7528");
        }
        this.builder.content(content);
        return this;
    }

    public MockRequest content(String content) {
        if (!this.contentMap.isEmpty()) {
            throw new RuntimeException("`MockRequest.content(String content)`\u4e0e`MockRequest.content(String, Object)`\u4e24\u4e2a\u65b9\u6cd5\u4e0d\u80fd\u6df7\u5408\u4f7f\u7528");
        }
        this.builder.content(content);
        this.characterEncoding(StandardCharsets.UTF_8);
        return this;
    }

    public MockRequest content(Object content) {
        if (!this.contentMap.isEmpty()) {
            throw new RuntimeException("`MockRequest.content(Object content)`\u4e0e`MockRequest.content(String, Object)`\u4e24\u4e2a\u65b9\u6cd5\u4e0d\u80fd\u6df7\u5408\u4f7f\u7528");
        }
        this.content(JSONUtil.toJsonStr((Object)content));
        this.contentType(MediaType.APPLICATION_JSON);
        return this;
    }

    public MockRequest content(String contentJsonKey, Object contentJsonValue) {
        try {
            if (ReflectionUtils.getFieldValue((Object)this.builder, (String)"content") != null) {
                throw new RuntimeException("`MockRequest.content(String, Object)`\u4e0e\u5176\u4ed6\u51e0\u4e2a\u91cd\u6784\u65b9\u6cd5\u4e0d\u80fd\u6df7\u5408\u4f7f\u7528");
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        this.contentMap.put(contentJsonKey, contentJsonValue);
        return this;
    }

    public MockRequest file(String multipartParamName, String filePath) {
        if (this.multipartBuilder == null) {
            MockMultipartHttpServletRequestBuilder newMultipartBuilder = MockMvcRequestBuilders.multipart((String)this.urlTemplate, (Object[])this.uriVars);
            newMultipartBuilder.merge((Object)this.builder);
            this.multipartBuilder = newMultipartBuilder;
            this.builder = newMultipartBuilder;
        }
        try {
            Resource[] resource = ResourceUtils.getResources((String)filePath);
            if (resource == null || resource.length == 0) {
                throw new TestException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + filePath);
            }
            this.multipartBuilder.file(new MockMultipartFile(multipartParamName, "", "", resource[0].getInputStream()));
        }
        catch (IOException e) {
            throw new TestException("\u8bbe\u7f6e\u6587\u4ef6\u53c2\u6570\u65f6\uff0c\u51fa\u73b0IO\u5f02\u5e38", (Throwable)e);
        }
        return this;
    }

    public MockRequest queryParam(String name, String ... values) {
        this.builder.queryParam(name, values);
        return this;
    }

    public MockRequest queryParams(MultiValueMap<String, String> params) {
        this.builder.queryParams(params);
        return this;
    }

    public MockResponse send() throws Exception {
        if (!this.contentMap.isEmpty()) {
            HashMap<String, Object> content = new HashMap<String, Object>(this.contentMap);
            this.contentMap.clear();
            this.content(content);
        }
        ResultActions resultActions = this.mockMvc.perform((RequestBuilder)this.builder);
        return new MockResponse(resultActions);
    }
}

