/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.test;

import cn.hutool.json.JSONUtil;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.spring.boot.test.result.CharacterEncodingResult;
import icu.easyj.spring.boot.test.result.ContentResult;
import icu.easyj.spring.boot.test.result.ContentTypeResult;
import icu.easyj.spring.boot.test.result.FileExportResult;
import icu.easyj.spring.boot.test.result.GenericContentResult;
import icu.easyj.spring.boot.test.result.HeaderResult;
import icu.easyj.spring.boot.test.result.StatusResult;
import icu.easyj.test.exception.TestException;
import java.io.UnsupportedEncodingException;
import org.junit.jupiter.api.Assertions;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultActions;

public class MockResponse {
    private static final String CHARSET_PREFIX = "charset=";
    private final ResultActions resultActions;
    private final MvcResult mvcResult;
    private MockHttpServletResponse response;

    public MockResponse(ResultActions resultActions) {
        this.resultActions = resultActions;
        this.mvcResult = resultActions.andReturn();
    }

    public StatusResult status() {
        return new StatusResult(this, this.getStatus());
    }

    public HeaderResult header() {
        return new HeaderResult(this, this.getResponse());
    }

    public ContentTypeResult contentType() {
        return new ContentTypeResult(this, this.getContentType());
    }

    public CharacterEncodingResult characterEncoding() {
        return new CharacterEncodingResult(this, this.getCharacterEncoding());
    }

    public <T> GenericContentResult<T> content(Class<T> contentClass) {
        return new GenericContentResult<T>(this, this.resultActions, this.getContent(contentClass));
    }

    public ContentResult content() {
        return new ContentResult(this, this.resultActions, this.getContentAsString());
    }

    public FileExportResult file() {
        return new FileExportResult(this, this.resultActions, this.mvcResult.getResponse().getContentAsByteArray());
    }

    public MockResponse isOk() {
        Assertions.assertEquals((int)HttpStatus.OK.value(), (int)this.mvcResult.getResponse().getStatus());
        return this;
    }

    private MockHttpServletResponse getResponse() {
        if (this.response == null) {
            MockHttpServletResponse response = this.mvcResult.getResponse();
            if (response.getContentType() == null || !response.getContentType().contains(CHARSET_PREFIX)) {
                try {
                    ReflectionUtils.setFieldValue((Object)response, (String)"characterEncoding", (Object)"UTF-8");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            this.response = response;
        }
        return this.response;
    }

    private int getStatus() {
        return this.getResponse().getStatus();
    }

    private String getContentType() {
        return this.getResponse().getContentType();
    }

    private String getCharacterEncoding() {
        return this.getResponse().getCharacterEncoding();
    }

    private String getContentAsString() {
        try {
            return this.getResponse().getContentAsString();
        }
        catch (UnsupportedEncodingException e) {
            throw new TestException("\u4e0d\u652f\u6301\u7684\u7f16\u7801", (Throwable)e);
        }
    }

    private <T> T getContent(Class<T> contentClass) {
        String content = this.getContentAsString();
        if (contentClass.equals(String.class)) {
            return (T)content;
        }
        return (T)JSONUtil.toBean((String)content, contentClass);
    }
}

