/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.test.result;

import icu.easyj.spring.boot.test.MockResponse;
import icu.easyj.spring.boot.test.result.BaseResult;
import icu.easyj.spring.boot.test.util.AssertionUtils;
import org.junit.jupiter.api.Assertions;
import org.springframework.http.HttpStatus;

public class StatusResult
extends BaseResult {
    private final HttpStatus status;

    public StatusResult(MockResponse mockResponse, int status) {
        super(mockResponse);
        this.status = HttpStatus.valueOf((int)status);
    }

    public MockResponse is(int expectedStatusValue) {
        Assertions.assertEquals((int)expectedStatusValue, (int)this.status.value());
        return super.end();
    }

    public MockResponse is(int ... expectedStatusValueArr) {
        for (int expectedStatusValue : expectedStatusValueArr) {
            if (expectedStatusValue != this.status.value()) continue;
            return super.end();
        }
        throw AssertionUtils.error("\u54cd\u5e94\u72b6\u6001\u4e0d\u6b63\u786e\u3002", expectedStatusValueArr, this.status.value());
    }

    public MockResponse is(HttpStatus expectedStatus) {
        Assertions.assertEquals((Object)expectedStatus, (Object)this.status);
        return super.end();
    }

    public MockResponse is(HttpStatus ... expectedStatusArr) {
        for (HttpStatus expectedStatus : expectedStatusArr) {
            if (expectedStatus != this.status) continue;
            return super.end();
        }
        throw AssertionUtils.error("\u54cd\u5e94\u72b6\u6001\u4e0d\u6b63\u786e\u3002", expectedStatusArr, this.status.value());
    }

    public MockResponse isOk() {
        return this.is(HttpStatus.OK);
    }

    public MockResponse isSeries(HttpStatus.Series expectedStatusSeries) {
        Assertions.assertEquals((Object)expectedStatusSeries, (Object)this.status.series());
        return super.end();
    }

    public MockResponse isSeries(HttpStatus.Series ... expectedStatusSeriesArr) {
        for (HttpStatus.Series expectedStatusSeries : expectedStatusSeriesArr) {
            if (expectedStatusSeries != this.status.series()) continue;
            return super.end();
        }
        throw AssertionUtils.error("\u54cd\u5e94\u72b6\u6001\u7cfb\u5217\u4e0d\u6b63\u786e\u3002", expectedStatusSeriesArr, this.status.series());
    }

    public MockResponse isInformationalSeries() {
        return this.isSeries(HttpStatus.Series.INFORMATIONAL);
    }

    public MockResponse isSuccessfulSeries() {
        return this.isSeries(HttpStatus.Series.SUCCESSFUL);
    }

    public MockResponse isRedirectionSeries() {
        return this.isSeries(HttpStatus.Series.REDIRECTION);
    }

    public MockResponse isClientErrorSeries() {
        return this.isSeries(HttpStatus.Series.CLIENT_ERROR);
    }

    public MockResponse isServerErrorSeries() {
        return this.isSeries(HttpStatus.Series.SERVER_ERROR);
    }
}

