/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.test.result;

import icu.easyj.spring.boot.test.MockResponse;
import icu.easyj.spring.boot.test.result.BaseResult;
import org.junit.jupiter.api.Assertions;
import org.springframework.http.MediaType;

public class ContentTypeResult
extends BaseResult {
    private final String contentType;

    public ContentTypeResult(MockResponse mockResponse, String contentType) {
        super(mockResponse);
        this.contentType = contentType.toLowerCase();
    }

    public MockResponse is(String expectedContentType) {
        Assertions.assertTrue((boolean)this.contentType.startsWith(expectedContentType));
        return super.end();
    }

    public MockResponse is(String expectedMediaType, String expectedMediaSubtype) {
        return this.is(expectedMediaType + "/" + expectedMediaSubtype);
    }

    public MockResponse is(MediaType expectedMediaType) {
        return this.is(expectedMediaType.getType(), expectedMediaType.getSubtype());
    }
}

