/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.test.result;

import icu.easyj.core.util.PatternUtils;
import icu.easyj.spring.boot.test.MockResponse;
import icu.easyj.spring.boot.test.result.BaseResult;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.PatternMatchUtils;

public class HeaderResult
extends BaseResult {
    private final MockHttpServletResponse response;

    public HeaderResult(MockResponse mockResponse, MockHttpServletResponse response) {
        super(mockResponse);
        this.response = response;
    }

    public HeaderResult is(String headerName, Object expectedHeaderValue) {
        Object headerValue = this.response.getHeaderValue(headerName);
        Assertions.assertEquals((Object)expectedHeaderValue, (Object)headerValue);
        return this;
    }

    public HeaderResult isMatch(String headerName, String expectedHeaderValuePattern) {
        Object headerValue = this.response.getHeaderValue(headerName);
        Assertions.assertNotNull((Object)headerValue);
        if (expectedHeaderValuePattern.startsWith("^")) {
            Assertions.assertTrue((boolean)PatternUtils.validate((String)expectedHeaderValuePattern, (CharSequence)headerValue.toString()));
        } else {
            Assertions.assertTrue((boolean)PatternMatchUtils.simpleMatch((String)expectedHeaderValuePattern, (String)headerValue.toString()));
        }
        return this;
    }

    public HeaderResult isMatch(String headerName, Pattern expectedHeaderValuePattern) {
        Object headerValue = this.response.getHeaderValue(headerName);
        Assertions.assertNotNull((Object)headerValue);
        Assertions.assertTrue((boolean)PatternUtils.validate((Pattern)expectedHeaderValuePattern, (CharSequence)headerValue.toString()));
        return this;
    }

    public HeaderResult contains(String ... expectedContainsHeaderNames) {
        for (String headerName : expectedContainsHeaderNames) {
            Assertions.assertTrue((boolean)this.response.containsHeader(headerName));
        }
        return this;
    }

    public HeaderResult notContains(String ... expectedNotContainsHeaderNames) {
        for (String headerName : expectedNotContainsHeaderNames) {
            Assertions.assertFalse((boolean)this.response.containsHeader(headerName));
        }
        return this;
    }
}

