/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.test.result;

import icu.easyj.core.util.PatternUtils;
import icu.easyj.spring.boot.test.MockResponse;
import icu.easyj.spring.boot.test.result.GenericContentResult;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.util.PatternMatchUtils;

public class ContentResult
extends GenericContentResult<String> {
    public ContentResult(MockResponse mockResponse, ResultActions resultActions, String content) {
        super(mockResponse, resultActions, content);
    }

    public ContentResult is(String expectedContent) {
        Assertions.assertEquals((Object)expectedContent, this.content);
        return this;
    }

    public ContentResult is(String jsonPathExpression, Object expectedValue) {
        try {
            this.resultActions.andExpect(MockMvcResultMatchers.jsonPath((String)jsonPathExpression, (Object[])new Object[0]).value(expectedValue));
            return this;
        }
        catch (Exception e) {
            throw new AssertionError("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01", e);
        }
    }

    public ContentResult is(int expectedSize) {
        return this.is("$.length()", String.valueOf(expectedSize));
    }

    public ContentResult isMatch(String expectedContentPattern) {
        if (expectedContentPattern.startsWith("^")) {
            Assertions.assertTrue((boolean)PatternUtils.validate((String)expectedContentPattern, (CharSequence)((CharSequence)this.content)));
        } else {
            Assertions.assertTrue((boolean)PatternMatchUtils.simpleMatch((String)expectedContentPattern, (String)((String)this.content)));
        }
        return this;
    }

    public ContentResult isMatch(Pattern expectedContentPattern) {
        Assertions.assertTrue((boolean)PatternUtils.validate((Pattern)expectedContentPattern, (CharSequence)((CharSequence)this.content)));
        return this;
    }
}

