/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.env;

import cn.hutool.core.io.IORuntimeException;
import icu.easyj.core.util.ResourceUtils;
import icu.easyj.spring.boot.env.EnvironmentUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class EasyjAppointedEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int ORDER = -2147483628;
    public static final String[] PATHS = new String[]{"config/project.yml", "config/project.yaml", "config/project.properties"};
    public static final String[] DIRECTORY_PATHS = new String[]{"config/default", "config/${project}/default", "config/${env}", "config/${project}/${env}"};

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String currentPropertySourceName;
        MutablePropertySources propertySources = environment.getPropertySources();
        String previousPropertySourceName = null;
        for (String path : PATHS) {
            PropertySource<?> propertySource;
            currentPropertySourceName = EnvironmentUtils.buildPropertySourceNameByPath(path);
            if (propertySources.contains(previousPropertySourceName) || (propertySource = EnvironmentUtils.addPropertySourceToLast(path, true, environment)) == null) continue;
            previousPropertySourceName = currentPropertySourceName;
        }
        String project = environment.getProperty("easyj.global.project");
        String env = EnvironmentUtils.getEnv(environment);
        if ("default".equalsIgnoreCase(env)) {
            env = null;
        }
        for (String dirPath : DIRECTORY_PATHS) {
            List<String> configFilePathList;
            if (dirPath.contains("${project}")) {
                if (!StringUtils.hasLength((String)project)) continue;
                dirPath = dirPath.replace("${project}", project);
            }
            if (dirPath.contains("${env}")) {
                if (!StringUtils.hasLength((String)env)) continue;
                dirPath = dirPath.replace("${env}", env);
            }
            if (CollectionUtils.isEmpty(configFilePathList = this.loadConfigFilePathList(dirPath))) continue;
            for (String path : configFilePathList) {
                PropertySource<?> propertySource;
                currentPropertySourceName = EnvironmentUtils.buildPropertySourceNameByPath(path);
                if (environment.getPropertySources().contains(currentPropertySourceName) || (propertySource = EnvironmentUtils.buildPropertySource(path, true)) == null) continue;
                if (previousPropertySourceName == null) {
                    EnvironmentUtils.addLastButBeforeDefault(propertySource, environment);
                } else {
                    propertySources.addBefore(previousPropertySourceName, propertySource);
                }
                previousPropertySourceName = currentPropertySourceName;
            }
        }
    }

    @Nullable
    private List<String> loadConfigFilePathList(String dirPath) {
        Resource[] resources = ResourceUtils.getResources((String)dirPath);
        if (resources == null || resources.length == 0) {
            return null;
        }
        ArrayList<String> filePathList = new ArrayList<String>();
        for (Resource resource : resources) {
            try {
                if (!resource.exists()) continue;
                for (String fileName : resource.getFile().list()) {
                    if (!fileName.endsWith(".yml") && !fileName.endsWith(".yaml") && !fileName.endsWith(".properties")) continue;
                    filePathList.add(dirPath + "/" + fileName);
                }
            }
            catch (IOException e) {
                throw new IORuntimeException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
        return filePathList;
    }

    public int getOrder() {
        return -2147483628;
    }
}

