/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.env;

import cn.hutool.core.io.IORuntimeException;
import icu.easyj.spring.boot.env.NotSupportedConfigFileException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class EnvironmentUtils {
    public static final String PREFIX = "easyj.global";
    public static final String PROJECT_KEY = "easyj.global.project";
    public static final String ENV_KEY = "easyj.global.env";
    public static final String DEFAULT_PROPERTY_SOURCE_NAME = "defaultProperties";

    public static void addOrMergeDefaultProperties(@Nullable Map<String, Object> source, @NonNull MutablePropertySources allSources) {
        if (!CollectionUtils.isEmpty(source)) {
            HashMap<String, Object> resultingSource = new HashMap<String, Object>();
            MapPropertySource defaultPropertySource = new MapPropertySource(DEFAULT_PROPERTY_SOURCE_NAME, resultingSource);
            if (allSources.contains(DEFAULT_PROPERTY_SOURCE_NAME)) {
                EnvironmentUtils.mergeIfPossible(source, allSources, resultingSource);
                allSources.replace(DEFAULT_PROPERTY_SOURCE_NAME, (PropertySource)defaultPropertySource);
            } else {
                resultingSource.putAll(source);
                allSources.addLast((PropertySource)defaultPropertySource);
            }
        }
    }

    public static void addOrMergeDefaultProperties(@Nullable Map<String, Object> source, ConfigurableEnvironment environment) {
        EnvironmentUtils.addOrMergeDefaultProperties(source, environment.getPropertySources());
    }

    private static void mergeIfPossible(@NonNull Map<String, Object> source, @NonNull MutablePropertySources allSources, @NonNull Map<String, Object> resultingSource) {
        PropertySource existingSource = allSources.get(DEFAULT_PROPERTY_SOURCE_NAME);
        if (existingSource != null) {
            Object underlyingSource = existingSource.getSource();
            if (underlyingSource instanceof Map) {
                resultingSource.putAll((Map)underlyingSource);
            }
            resultingSource.putAll(source);
        }
    }

    @Nullable
    public static Properties buildProperties(@NonNull String configFilePath) {
        Properties properties;
        ClassPathResource configFileResource = new ClassPathResource(configFilePath);
        if (!configFileResource.exists()) {
            return null;
        }
        if (configFilePath.endsWith(".yml") || configFilePath.endsWith(".yaml")) {
            YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
            yaml.setResources(new Resource[]{configFileResource});
            properties = yaml.getObject();
        } else if (configFilePath.endsWith(".properties")) {
            PropertiesFactoryBean pro = new PropertiesFactoryBean();
            pro.setLocation((Resource)configFileResource);
            try {
                properties = pro.getObject();
            }
            catch (IOException e) {
                throw new IORuntimeException("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff1a" + configFilePath, (Throwable)e);
            }
        } else {
            throw new NotSupportedConfigFileException("\u6682\u4e0d\u652f\u6301\u8be5\u914d\u7f6e\u6587\u4ef6\u7684\u89e3\u6790\uff1a" + configFilePath);
        }
        return properties;
    }

    @NonNull
    public static String buildPropertySourceNameByPath(@NonNull String configFilePath) {
        return "EasyJ loaded resource '" + configFilePath + "'";
    }

    @Nullable
    public static PropertySource<?> buildPropertySource(@NonNull String configFilePath, boolean immutable) {
        Properties properties = EnvironmentUtils.buildProperties(configFilePath);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        String propertySourceName = EnvironmentUtils.buildPropertySourceNameByPath(configFilePath);
        Map<Object, Object> source = immutable ? Collections.unmodifiableMap(properties) : properties;
        return new OriginTrackedMapPropertySource(propertySourceName, (Map)source, immutable);
    }

    @Nullable
    public static PropertySource<?> addPropertySourceToLast(@NonNull String configFilePath, boolean immutable, @NonNull ConfigurableEnvironment environment) {
        PropertySource<?> propertySource = EnvironmentUtils.buildPropertySource(configFilePath, immutable);
        if (propertySource != null) {
            EnvironmentUtils.addLastButBeforeDefault(propertySource, environment);
            return propertySource;
        }
        return null;
    }

    public static void addLastButBeforeDefault(@NonNull PropertySource<?> propertySource, @NonNull ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        if (propertySources.contains(DEFAULT_PROPERTY_SOURCE_NAME)) {
            propertySources.addBefore(DEFAULT_PROPERTY_SOURCE_NAME, propertySource);
        } else {
            propertySources.addLast(propertySource);
        }
    }

    @Nullable
    public static String getEnv(@NonNull ConfigurableEnvironment environment) {
        String env = environment.getProperty(ENV_KEY);
        if (!StringUtils.hasText((String)env) && !StringUtils.hasText((String)(env = environment.getProperty("spring.profiles.active")))) {
            env = environment.getProperty("spring.profiles.active[0]");
        }
        return env;
    }
}

