/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.util;

import cn.hutool.core.io.IORuntimeException;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.ResourceUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.spring.boot.exception.NotSupportedConfigFileTypeException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class EnvironmentUtils {
    public static final String PREFIX = "easyj.global";
    public static final String AREA_KEY = "easyj.global.area";
    public static final String PROJECT_KEY = "easyj.global.project";
    public static final String ENV_KEY = "easyj.global.env";
    public static final String DEFAULT_PROPERTY_SOURCE_NAME = "defaultProperties";

    public static void addOrMergeDefaultProperties(@Nullable Map<String, Object> source, @NonNull MutablePropertySources allSources) {
        if (!MapUtils.isEmpty(source)) {
            HashMap<String, Object> resultingSource = new HashMap<String, Object>(source.size());
            MapPropertySource defaultPropertySource = new MapPropertySource(DEFAULT_PROPERTY_SOURCE_NAME, resultingSource);
            if (allSources.contains(DEFAULT_PROPERTY_SOURCE_NAME)) {
                EnvironmentUtils.mergeIfPossible(source, allSources, resultingSource);
                allSources.replace(DEFAULT_PROPERTY_SOURCE_NAME, (PropertySource)defaultPropertySource);
            } else {
                resultingSource.putAll(source);
                allSources.addLast((PropertySource)defaultPropertySource);
            }
        }
    }

    public static void addOrMergeDefaultProperties(@Nullable Map<String, Object> source, ConfigurableEnvironment environment) {
        EnvironmentUtils.addOrMergeDefaultProperties(source, environment.getPropertySources());
    }

    private static void mergeIfPossible(@NonNull Map<String, Object> source, @NonNull MutablePropertySources allSources, @NonNull Map<String, Object> resultingSource) {
        PropertySource existingSource = allSources.get(DEFAULT_PROPERTY_SOURCE_NAME);
        if (existingSource != null) {
            Object underlyingSource = existingSource.getSource();
            if (underlyingSource instanceof Map) {
                resultingSource.putAll((Map)underlyingSource);
            }
            resultingSource.putAll(source);
        }
    }

    @Nullable
    public static Properties buildProperties(@NonNull Resource configFileResource) {
        Properties properties;
        String configFileName = configFileResource.getFilename();
        if (configFileName == null) {
            return null;
        }
        if (configFileName.endsWith(".yml") || configFileName.endsWith(".yaml")) {
            YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
            yaml.setResources(new Resource[]{configFileResource});
            properties = yaml.getObject();
        } else if (configFileName.endsWith(".properties")) {
            PropertiesFactoryBean pro = new PropertiesFactoryBean();
            pro.setSingleton(false);
            pro.setLocation(configFileResource);
            try {
                properties = pro.getObject();
            }
            catch (IOException e) {
                throw new IORuntimeException("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff1a" + configFileName, (Throwable)e);
            }
        } else {
            throw new NotSupportedConfigFileTypeException("\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u7684\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\uff0c\u6587\u4ef6\u540d\uff1a" + configFileName);
        }
        return properties;
    }

    @Nullable
    public static Properties buildProperties(@NonNull String configFilePath) {
        ClassPathResource configFileResource = new ClassPathResource(configFilePath);
        if (!configFileResource.exists()) {
            return null;
        }
        return EnvironmentUtils.buildProperties((Resource)configFileResource);
    }

    @NonNull
    public static String buildPropertySourceNameByPath(@NonNull String configFilePath) {
        return "[EasyJ] Config resource '" + configFilePath + "'";
    }

    @NonNull
    public static String buildPropertySourceNameByPath(@NonNull Resource configFileResource) {
        String configFilePath = ResourceUtils.getResourceUri((Resource)configFileResource);
        return EnvironmentUtils.buildPropertySourceNameByPath(configFilePath);
    }

    @Nullable
    public static MapPropertySource buildPropertySource(@NonNull Resource configFileResource, boolean immutable) {
        Properties properties = EnvironmentUtils.buildProperties(configFileResource);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        String propertySourceName = EnvironmentUtils.buildPropertySourceNameByPath(configFileResource);
        Map<Object, Object> source = immutable ? Collections.unmodifiableMap(properties) : properties;
        return EnvironmentUtils.newMapPropertySource(propertySourceName, source, immutable);
    }

    @NonNull
    public static MapPropertySource newMapPropertySource(@NonNull String propertySourceName, @NonNull Map<String, Object> source, boolean immutable) {
        try {
            Class clazz = ReflectionUtils.getClassByName((String)"org.springframework.boot.env.OriginTrackedMapPropertySource");
            try {
                Constructor constructor = clazz.getConstructor(String.class, Map.class, Boolean.TYPE);
                return (MapPropertySource)constructor.newInstance(propertySourceName, source, immutable);
            }
            catch (NoSuchMethodException e) {
                Constructor constructor = clazz.getConstructor(String.class, Map.class);
                return (MapPropertySource)constructor.newInstance(propertySourceName, source);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignore) {
            return new MapPropertySource(propertySourceName, source);
        }
    }

    @Nullable
    public static MapPropertySource buildPropertySource(@NonNull String configFilePath, boolean immutable) {
        ClassPathResource configFileResource = new ClassPathResource(configFilePath);
        if (!configFileResource.exists()) {
            return null;
        }
        return EnvironmentUtils.buildPropertySource((Resource)configFileResource, immutable);
    }

    @Nullable
    public static PropertySource<?> addPropertySourceToLast(@NonNull Resource configFileResource, boolean immutable, @NonNull ConfigurableEnvironment environment) {
        MapPropertySource propertySource = EnvironmentUtils.buildPropertySource(configFileResource, immutable);
        if (propertySource != null) {
            EnvironmentUtils.addLastButBeforeDefault(propertySource, environment);
            return propertySource;
        }
        return null;
    }

    @Nullable
    public static PropertySource<?> addPropertySourceToLast(@NonNull String configFilePath, boolean immutable, @NonNull ConfigurableEnvironment environment) {
        ClassPathResource configFileResource = new ClassPathResource(configFilePath);
        if (!configFileResource.exists()) {
            return null;
        }
        return EnvironmentUtils.addPropertySourceToLast((Resource)configFileResource, immutable, environment);
    }

    public static void addLastButBeforeDefault(@NonNull PropertySource<?> propertySource, @NonNull ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        if (propertySources.contains(DEFAULT_PROPERTY_SOURCE_NAME)) {
            propertySources.addBefore(DEFAULT_PROPERTY_SOURCE_NAME, propertySource);
        } else {
            propertySources.addLast(propertySource);
        }
    }

    @Nullable
    public static String getEnv(@NonNull ConfigurableEnvironment environment) {
        String env = environment.getProperty(ENV_KEY);
        if (StringUtils.isBlank((CharSequence)env) && StringUtils.isBlank((CharSequence)(env = environment.getProperty("spring.profiles.active")))) {
            env = environment.getProperty("spring.profiles.active[0]");
        }
        return env;
    }

    @NonNull
    public static List<String> getPropertyList(@NonNull ConfigurableEnvironment environment, String propertyName) {
        ArrayList<String> propertyList = new ArrayList<String>();
        String property = environment.getProperty(propertyName);
        if (property != null) {
            propertyList.add(property);
        } else {
            int i = 0;
            while ((property = environment.getProperty(propertyName + "[" + i + "]")) != null) {
                propertyList.add(property);
                ++i;
            }
        }
        return propertyList;
    }

    @NonNull
    public static List<String> getPropertyList(@NonNull PropertySource<?> propertySource, String propertyName) {
        ArrayList<String> propertyList;
        block5: {
            String property;
            block3: {
                block4: {
                    String[] propertyArr;
                    propertyList = new ArrayList<String>();
                    property = EnvironmentUtils.getPropertyStr(propertySource, propertyName);
                    if (property == null) break block3;
                    if (!property.contains(",")) break block4;
                    for (String pro : propertyArr = property.split(",")) {
                        if (!StringUtils.isNotBlank((CharSequence)pro)) continue;
                        propertyList.add(pro.trim());
                    }
                    break block5;
                }
                if (!StringUtils.isNotBlank((CharSequence)property)) break block5;
                propertyList.add(property.trim());
                break block5;
            }
            int i = 0;
            while ((property = EnvironmentUtils.getPropertyStr(propertySource, propertyName + "[" + i + "]")) != null) {
                if (StringUtils.isNotBlank((CharSequence)property)) {
                    propertyList.add(property.trim());
                }
                ++i;
            }
        }
        return propertyList;
    }

    @Nullable
    private static String getPropertyStr(@NonNull PropertySource<?> propertySource, String propertyName) {
        Object propertyObj = propertySource.getProperty(propertyName);
        if (propertyObj == null) {
            return null;
        }
        return String.valueOf(propertyObj);
    }
}

