/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.spring.boot.util;

import icu.easyj.core.util.CollectionUtils;
import icu.easyj.web.exception.FilterDisabledException;
import icu.easyj.web.filter.IFilterProperties;
import java.util.Collection;
import javax.servlet.Filter;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;

public abstract class FilterRegistrationUtils {
    public static <F extends Filter, P extends IFilterProperties> FilterRegistrationBean register(F filter, P properties, Integer defaultOrder) {
        if (!properties.isEnabled()) {
            throw new FilterDisabledException("\u5f53\u524d\u8fc7\u6ee4\u5668\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6ce8\u518c");
        }
        FilterRegistrationBean registration = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
        registration.setName(filter.getClass().getSimpleName());
        if (properties.getOrder() == null) {
            properties.setOrder(defaultOrder != null ? defaultOrder : Integer.MAX_VALUE);
        }
        registration.setOrder(properties.getOrder().intValue());
        String[] urlPatterns = CollectionUtils.isEmpty((Collection)properties.getUrlPatterns()) ? new String[]{"/*"} : properties.getUrlPatterns().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        registration.addUrlPatterns(urlPatterns);
        return registration;
    }
}

