/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class PatternUtils {
    public static final String REGEX_BASE64 = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
    public static final Pattern P_BASE64 = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");
    public static final String REGEX_BASE64_2 = "^[A-Za-z0-9+/]+={0,2}$";
    public static final Pattern P_BASE64_2 = Pattern.compile("^[A-Za-z0-9+/]+={0,2}$");

    public static boolean validate(@NonNull Pattern pattern, @Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        Assert.notNull((Object)pattern, (String)"'pattern' must be not null");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static boolean validate(@NonNull String regex, @Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        Assert.notNull((Object)regex, (String)"'regex' must be not null");
        Pattern p = Pattern.compile(regex);
        return PatternUtils.validate(p, str);
    }

    public static boolean isBase64Char(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || '=' == c || '/' == c || '+' == c;
    }

    public static boolean isBase64Str(CharSequence str) {
        if (str == null || str.length() < 4) {
            return false;
        }
        String s = str.toString();
        char c = s.charAt(s.length() - 1);
        if (!PatternUtils.isBase64Char(c)) {
            return false;
        }
        return PatternUtils.validate(P_BASE64, (CharSequence)s);
    }

    public static boolean isBase64Str2(CharSequence str) {
        if (str == null || str.length() < 4) {
            return false;
        }
        String s = str.toString();
        char c = s.charAt(s.length() - 1);
        if (!PatternUtils.isBase64Char(c)) {
            return false;
        }
        return PatternUtils.validate(P_BASE64_2, (CharSequence)s);
    }
}

