/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.crypto;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import icu.easyj.crypto.symmetric.HutoolSymmetricCryptoAdapter;
import icu.easyj.crypto.symmetric.ISymmetricCrypto;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class CryptoFactory {
    public static ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull String key, String iv, Charset charset) {
        Assert.notNull((Object)algorithm, (String)"algorithmStr must be not null");
        Assert.notNull((Object)key, (String)"key must be not null");
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        byte[] keyBytes = key.getBytes(charset);
        byte[] ivBytes = StringUtils.hasLength((String)iv) ? iv.getBytes(charset) : null;
        return CryptoFactory.getSymmetricCrypto(algorithm, keyBytes, ivBytes);
    }

    public static ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull String key, String iv) {
        return CryptoFactory.getSymmetricCrypto(algorithm, key, iv, StandardCharsets.UTF_8);
    }

    public static ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull byte[] key, byte[] iv) {
        Assert.notNull((Object)algorithm, (String)"algorithmStr must be not null");
        Assert.notNull((Object)key, (String)"key must be not null");
        String algorithmType = algorithm.substring(0, algorithm.indexOf(47));
        SecretKey secretKey = SecureUtil.generateKey((String)algorithmType, (byte[])key);
        IvParameterSpec parameterSpec = ArrayUtils.isNotEmpty((byte[])iv) ? new IvParameterSpec(iv) : null;
        SymmetricCrypto symmetricCrypto = new SymmetricCrypto(algorithm, secretKey, (AlgorithmParameterSpec)parameterSpec);
        return new HutoolSymmetricCryptoAdapter(symmetricCrypto);
    }
}

