/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.crypto.symmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

public interface ISymmetricCrypto
extends Serializable {
    public byte[] encrypt(byte[] var1);

    public void encrypt(InputStream var1, OutputStream var2, boolean var3) throws IORuntimeException;

    default public String encryptHex(byte[] data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }

    default public String encryptBase64(byte[] data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    default public byte[] encrypt(String data, String charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (String)charset));
    }

    default public byte[] encrypt(String data, Charset charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)charset));
    }

    default public String encryptHex(String data, String charset) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset));
    }

    default public String encryptHex(String data, Charset charset) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset));
    }

    default public String encryptBase64(String data, String charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    default public String encryptBase64(String data, Charset charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    default public byte[] encrypt(String data) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)CharsetUtil.CHARSET_UTF_8));
    }

    default public String encryptHex(String data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }

    default public String encryptBase64(String data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    default public byte[] encrypt(InputStream data) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes((InputStream)data));
    }

    default public String encryptHex(InputStream data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }

    default public String encryptBase64(InputStream data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    public byte[] decrypt(byte[] var1);

    public void decrypt(InputStream var1, OutputStream var2, boolean var3) throws IORuntimeException;

    default public String decryptStr(byte[] bytes, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(bytes), (Charset)charset);
    }

    default public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decrypt(String data) {
        return this.decrypt(SecureUtil.decode((String)data));
    }

    default public String decryptBase64(String data, Charset charset) {
        return this.decryptStr(Base64.decode((CharSequence)data), charset);
    }

    default public String decryptBase64(String data) {
        return this.decryptBase64(data, CharsetUtil.CHARSET_UTF_8);
    }

    default public String decryptHex(String data, Charset charset) {
        return this.decryptStr(HexUtil.decodeHex((String)data), charset);
    }

    default public String decryptHex(String data) {
        return this.decryptHex(data, CharsetUtil.CHARSET_UTF_8);
    }

    default public String decryptStr(String data, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(data), (Charset)charset);
    }

    default public String decryptStr(String data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decrypt(InputStream data) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes((InputStream)data));
    }

    default public String decryptStr(InputStream data, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(data), (Charset)charset);
    }

    default public String decryptStr(InputStream data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }
}

