/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.code.analysis;

import icu.easyj.core.code.analysis.CodeAnalysisResult;
import icu.easyj.core.util.PatternUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class CodeAnalysisUtils {
    @Nullable
    public static Object[] analysisParameters(String parametersStr, int limitParameterSize) {
        if (!StringUtils.hasLength((String)parametersStr) || limitParameterSize <= 0) {
            return null;
        }
        Matcher mParameter = PatternUtils.P_CODE_DATA_VALUE.matcher(parametersStr);
        ArrayList<Object> parameterList = new ArrayList<Object>();
        block12: while (parameterList.size() < limitParameterSize && mParameter.find()) {
            String parameter;
            switch (parameter = mParameter.group()) {
                case "null": {
                    parameterList.add(null);
                    continue block12;
                }
                case "true": {
                    parameterList.add(true);
                    continue block12;
                }
                case "false": {
                    parameterList.add(false);
                    continue block12;
                }
            }
            if (!parameter.startsWith("'") && !parameter.startsWith("\"")) {
                if (parameter.contains(".")) {
                    parameterList.add(Double.valueOf(parameter));
                    continue;
                }
                if (parameter.toUpperCase().endsWith("L")) {
                    parameterList.add(Long.valueOf(parameter.substring(0, parameter.length() - 1)));
                    continue;
                }
                try {
                    parameterList.add(Integer.valueOf(parameter));
                }
                catch (NumberFormatException e) {
                    parameterList.add(Long.valueOf(parameter));
                }
                continue;
            }
            String c = String.valueOf(parameter.charAt(0));
            if ((parameter = parameter.substring(1, parameter.length() - 1)).contains("\\" + c)) {
                parameter = parameter.replace("\\" + c, c);
            }
            parameterList.add(parameter);
        }
        if (parameterList.isEmpty()) {
            return null;
        }
        return parameterList.toArray(new Object[0]);
    }

    @Nullable
    public static Object[] analysisParameters(String parametersStr) {
        return CodeAnalysisUtils.analysisParameters(parametersStr, Integer.MAX_VALUE);
    }

    @Nullable
    public static CodeAnalysisResult analysisCode(String code, int limitParameterSize, boolean isRigorous) {
        String fieldOrMethodName;
        if (code == null) {
            throw new IllegalArgumentException("code must be not null");
        }
        Matcher m = (isRigorous ? PatternUtils.P_CODE_LINE : PatternUtils.P_CODE_LINE2).matcher(code.trim());
        if (!m.matches()) {
            return null;
        }
        CodeAnalysisResult result = new CodeAnalysisResult();
        String variableName = m.groupCount() > 0 ? m.group(1) : null;
        result.setVariableName(variableName);
        String string = fieldOrMethodName = m.groupCount() >= 4 ? m.group(3) : null;
        if (code.contains("(")) {
            result.setMethodName(fieldOrMethodName);
            String parametersStr = m.groupCount() >= 6 ? m.group(5) : null;
            Object[] parameters = CodeAnalysisUtils.analysisParameters(parametersStr, limitParameterSize);
            result.setParameters(parameters);
        } else {
            result.setFieldName(fieldOrMethodName);
        }
        return result;
    }

    public static CodeAnalysisResult analysisCode(String code, boolean isRigorous) {
        return CodeAnalysisUtils.analysisCode(code, Integer.MAX_VALUE, isRigorous);
    }

    public static CodeAnalysisResult analysisCode(String code, int limitParameterSize) {
        return CodeAnalysisUtils.analysisCode(code, limitParameterSize, false);
    }

    public static CodeAnalysisResult analysisCode(String code) {
        return CodeAnalysisUtils.analysisCode(code, Integer.MAX_VALUE, false);
    }
}

