/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class ResourceUtils {
    private static final ResourcePatternResolver RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver();

    public static Resource[] getResources(String locationPattern) {
        try {
            return RESOURCE_RESOLVER.getResources(locationPattern);
        }
        catch (IOException var3) {
            return new Resource[0];
        }
    }

    public static Resource[] getResources(String[] locationPatternArr) {
        return (Resource[])Stream.of((Object[])Optional.ofNullable(locationPatternArr).orElse(new String[0])).flatMap(locationPattern -> Stream.of(ResourceUtils.getResources(locationPattern))).toArray(Resource[]::new);
    }
}

