/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.filter;

import cn.hutool.core.collection.CollectionUtil;
import icu.easyj.core.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FilterExclusion {
    private final String method;
    private final String uriPattern;

    public FilterExclusion(@NonNull String configStr) {
        Assert.notNull((Object)configStr, (String)"configStr must be not null");
        if (configStr.contains(":")) {
            String[] arr = configStr.split(":");
            if (arr.length == 1) {
                this.method = null;
                this.uriPattern = arr[0].trim();
            } else {
                this.method = arr[0].trim().toUpperCase();
                this.uriPattern = arr[1].trim();
            }
        } else {
            this.method = null;
            this.uriPattern = configStr.trim();
        }
    }

    public static Map<String, List<String>> convert(List<String> configList) {
        if (CollectionUtils.isEmpty(configList)) {
            return null;
        }
        HashMap<String, List<String>> listMap = new HashMap<String, List<String>>(4);
        for (String configStr : configList) {
            if (!StringUtils.hasText((String)configStr)) continue;
            FilterExclusion info = new FilterExclusion(configStr);
            String method = info.getMethod();
            String pattern = info.getUriPattern();
            FilterExclusion.addPatternToListMap(listMap, method, pattern);
        }
        return listMap;
    }

    public static Map<String, List<String>> convert(String[] configArr) {
        return FilterExclusion.convert(CollectionUtil.toList((Object[])configArr));
    }

    public static Map<String, List<String>> convert(String configStr) {
        return FilterExclusion.convert(configStr.split(","));
    }

    private static void addPatternToListMap(Map<String, List<String>> listMap, String method, String pattern) {
        if (!StringUtils.hasText((String)pattern)) {
            return;
        }
        MapUtils.computeIfAbsent(listMap, method, k -> new ArrayList()).add(pattern);
    }

    public String getMethod() {
        return this.method;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }
}

