/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class QueryStringUtils {
    @NonNull
    public static Map<String, String[]> parse(@Nullable String queryString) {
        if (!StringUtils.hasLength((String)queryString)) {
            return new HashMap<String, String[]>(0);
        }
        String[] paramArr = queryString.split("&");
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(paramArr.length);
        for (String param : paramArr) {
            String[] values;
            String key;
            if (!StringUtils.hasText((String)param)) continue;
            int idx = param.indexOf("=");
            if (idx >= 0) {
                key = idx == 0 ? "" : param.substring(0, idx);
                String value = param.substring(idx + 1);
                try {
                    value = URLDecoder.decode(value, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                values = parameterMap.containsKey(key) ? (String[])ArrayUtils.addAll((Object[])((Object[])parameterMap.get(key)), (Object[])new String[]{value}) : new String[]{value};
            } else {
                key = param;
                values = new String[]{""};
            }
            parameterMap.put(key, values);
        }
        return parameterMap;
    }
}

