/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.wrapper;

import icu.easyj.web.util.QueryStringUtils;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class QueryStringHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final String queryString;
    private Map<String, String[]> parameterMap;

    public QueryStringHttpServletRequestWrapper(HttpServletRequest request, String queryString) {
        super(request);
        this.queryString = queryString == null ? "" : queryString;
    }

    @NonNull
    public String getQueryString() {
        return this.queryString;
    }

    @NonNull
    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = QueryStringUtils.parse(this.queryString);
        }
        return this.parameterMap;
    }

    @NonNull
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    @Nullable
    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    @Nullable
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            return values[0];
        }
        for (String value : values) {
            if (!StringUtils.hasText((String)value)) continue;
            return value;
        }
        return values[0];
    }
}

