/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import java.util.regex.Pattern;

public abstract class Base64Utils {
    public static final String REGEX_CRLF = "[\\r\\n]";
    public static final Pattern P_CRLF = Pattern.compile("[\\r\\n]+");
    private static final byte[] BASE64_CHAR_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 43, -1, -1, -1, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -1, -1, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    public static final char PADDING_CHAR = '=';

    public static String normalize(String base64Str) {
        if (base64Str.contains(" ")) {
            base64Str = base64Str.replace(" ", "+");
        }
        if (base64Str.contains("%")) {
            if (base64Str.contains("%25")) {
                base64Str = base64Str.replaceAll("%25", "%");
            }
            if (base64Str.contains("%2B")) {
                base64Str = base64Str.replace("%2B", "+");
            }
            if (base64Str.contains("%2F")) {
                base64Str = base64Str.replace("%2F", "/");
            }
            if (base64Str.endsWith("%3D")) {
                base64Str = base64Str.replace("%3D", "=");
            }
        }
        if (base64Str.contains("\n") || base64Str.contains("\r")) {
            base64Str = P_CRLF.matcher(base64Str).replaceAll("");
        }
        return base64Str;
    }

    public static boolean isBase64Char(char c) {
        return c < BASE64_CHAR_TABLE.length && BASE64_CHAR_TABLE[c] != -1;
    }

    public static boolean isBase64(CharSequence str) {
        int length;
        if (str == null || str.length() < 2) {
            return false;
        }
        char[] charArr = str.toString().toCharArray();
        if (charArr[(length = charArr.length) - 1] == '=') {
            if (str.length() % 4 != 0) {
                return false;
            }
            if (charArr[--length - 1] == '=') {
                --length;
            }
        }
        for (int i = 0; i < length; ++i) {
            char c = charArr[i];
            if (Base64Utils.isBase64Char(c)) continue;
            return false;
        }
        return true;
    }
}

