/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.Base64Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class PatternUtils {
    public static final String REGEX_BASE64 = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
    public static final Pattern P_BASE64 = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");
    public static final String REGEX_BASE64_2 = "^[A-Za-z0-9+/]+={0,2}$";
    public static final Pattern P_BASE64_2 = Pattern.compile("^[A-Za-z0-9+/]+={0,2}$");
    public static final String REGEX_CODE_STRING1 = "'((?<=\\\\)'|[^'])*'";
    public static final String REGEX_CODE_STRING2 = "\"((?<=\\\\)\"|[^\"])*\"";
    public static final String REGEX_CODE_STRING = "('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")";
    public static final String REGEX_CODE_NUMBER = "(\\d+((\\.\\d*)|[lL])?)";
    public static final String REGEX_CODE_BOOLEAN = "(true|false)";
    public static final String REGEX_CODE_NULL = "null";
    public static final String REGEX_CODE_VALUE = "(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null)";
    public static final Pattern P_CODE_DATA_VALUE = Pattern.compile("(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null)");
    public static final String REGEX_CODE_LINE = "^(\\w+)(\\.(\\w+)(\\(((('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null)(,\\s{0,1}(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null))*)?\\)(?=(;|$)))?)?;?$";
    public static final Pattern P_CODE_LINE = Pattern.compile("^(\\w+)(\\.(\\w+)(\\(((('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null)(,\\s{0,1}(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null))*)?\\)(?=(;|$)))?)?;?$");
    public static final String REGEX_CODE_LINE2 = "^(\\w+)\\s*(\\.\\s*(\\w+)\\s*(\\(\\s*((('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null)\\s*(,\\s*(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null)\\s*)*)?\\)(?=(\\s|;|$)))?)?\\s*;?$";
    public static final Pattern P_CODE_LINE2 = Pattern.compile("^(\\w+)\\s*(\\.\\s*(\\w+)\\s*(\\(\\s*((('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null)\\s*(,\\s*(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|(\\d+((\\.\\d*)|[lL])?)|(true|false)|null)\\s*)*)?\\)(?=(\\s|;|$)))?)?\\s*;?$");

    public static boolean validate(@NonNull Pattern pattern, @Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        Assert.notNull((Object)pattern, (String)"'pattern' must be not null");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static boolean validate(@NonNull String regex, @Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        Assert.notNull((Object)regex, (String)"'regex' must be not null");
        Pattern p = Pattern.compile(regex);
        return PatternUtils.validate(p, str);
    }

    @Deprecated
    public static boolean isBase64Char(char c) {
        return Base64Utils.isBase64Char(c);
    }

    @Deprecated
    public static boolean isBase64Str(CharSequence str) {
        return Base64Utils.isBase64(str);
    }

    public static boolean isBase64Str2(CharSequence str) {
        if (str == null || str.length() < 4) {
            return false;
        }
        String s = str.toString();
        char c = s.charAt(s.length() - 1);
        if (!Base64Utils.isBase64Char(c)) {
            return false;
        }
        return PatternUtils.validate(P_BASE64_2, (CharSequence)s);
    }
}

