/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.config;

import icu.easyj.core.env.EnvironmentType;
import icu.easyj.core.env.RunMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GlobalConfigs {
    private String area;
    private String areaName;
    private String project;
    private String projectName;
    private String application;
    private String applicationName;
    private String env;
    private String envName;
    private EnvironmentType envType = EnvironmentType.PROD;
    private RunMode runMode = RunMode.RELEASE;
    private boolean inUnitTest = false;
    private final Map<Object, Object> configs = new HashMap<Object, Object>(4);

    private GlobalConfigs() {
    }

    private static GlobalConfigs getInstance() {
        return SingletonHolder.INSTANCE.getGlobalConfigs();
    }

    public static String getArea() {
        return GlobalConfigs.getInstance().area;
    }

    public static String getAreaName() {
        return GlobalConfigs.getInstance().areaName;
    }

    public static String getProject() {
        return GlobalConfigs.getInstance().project;
    }

    public static String getProjectName() {
        return GlobalConfigs.getInstance().projectName;
    }

    public static String getApplication() {
        return GlobalConfigs.getInstance().application;
    }

    public static String getApplicationName() {
        return GlobalConfigs.getInstance().applicationName;
    }

    public static String getEnv() {
        return GlobalConfigs.getInstance().env;
    }

    public static String getEnvName() {
        return GlobalConfigs.getInstance().envName;
    }

    public static EnvironmentType getEnvType() {
        return GlobalConfigs.getInstance().envType;
    }

    public static boolean isProdEnv() {
        return EnvironmentType.PROD == GlobalConfigs.getEnvType();
    }

    public static boolean isNotProdEnv() {
        return !GlobalConfigs.isProdEnv();
    }

    public static boolean isSandboxEnv() {
        return EnvironmentType.SANDBOX == GlobalConfigs.getEnvType();
    }

    public static boolean isNotSandboxEnv() {
        return !GlobalConfigs.isSandboxEnv();
    }

    public static boolean isTestEnv() {
        return EnvironmentType.TEST == GlobalConfigs.getEnvType();
    }

    public static boolean isNotTestEnv() {
        return !GlobalConfigs.isTestEnv();
    }

    public static boolean isDevEnv() {
        return EnvironmentType.DEV == GlobalConfigs.getEnvType();
    }

    public static boolean isNotDevEnv() {
        return !GlobalConfigs.isDevEnv();
    }

    public static RunMode getRunMode() {
        return GlobalConfigs.getInstance().runMode;
    }

    public static boolean isReleaseMode() {
        return RunMode.RELEASE == GlobalConfigs.getRunMode();
    }

    public static boolean isDebugMode() {
        return RunMode.DEBUG == GlobalConfigs.getRunMode();
    }

    public static boolean isInUnitTest() {
        return GlobalConfigs.getInstance().inUnitTest;
    }

    public static Map<Object, Object> getConfigs() {
        return Collections.unmodifiableMap(GlobalConfigs.getInstance().configs);
    }

    public static <T> T getConfig(Object key) {
        return (T)GlobalConfigs.getInstance().configs.get(key);
    }

    static void setArea(String area) {
        GlobalConfigs.getInstance().area = area;
    }

    static void setAreaName(String areaName) {
        GlobalConfigs.getInstance().areaName = areaName;
    }

    static void setProject(String project) {
        GlobalConfigs.getInstance().project = project;
    }

    static void setProjectName(String projectName) {
        GlobalConfigs.getInstance().projectName = projectName;
    }

    static void setApplication(String application) {
        GlobalConfigs.getInstance().application = application;
    }

    static void setApplicationName(String applicationName) {
        GlobalConfigs.getInstance().applicationName = applicationName;
    }

    static void setEnv(String env) {
        GlobalConfigs.getInstance().env = env;
    }

    static void setEnvName(String envName) {
        GlobalConfigs.getInstance().envName = envName;
    }

    static void setEnvType(EnvironmentType envType) {
        GlobalConfigs.getInstance().envType = envType;
    }

    static void setRunMode(RunMode runMode) {
        GlobalConfigs.getInstance().runMode = runMode;
    }

    static void setInUnitTest(boolean inUnitTest) {
        GlobalConfigs.getInstance().inUnitTest = inUnitTest;
    }

    static synchronized void addConfig(Object key, Object value) {
        if (value != null) {
            GlobalConfigs.getInstance().configs.put(key, value);
        }
    }

    static synchronized <K, V> void addConfigs(Map<K, V> configs) {
        if (configs != null && !configs.isEmpty()) {
            GlobalConfigs.getInstance().configs.putAll(configs);
        }
    }

    private static enum SingletonHolder {
        INSTANCE;

        private final GlobalConfigs globalConfigs = new GlobalConfigs();

        public GlobalConfigs getGlobalConfigs() {
            return this.globalConfigs;
        }
    }
}

