/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.loader;

import icu.easyj.core.executor.Initialize;
import icu.easyj.core.loader.EnhancedServiceNotFoundException;
import icu.easyj.core.loader.ExtensionDefinition;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.Scope;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.MapUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class EnhancedServiceLoader {
    public static <S> S load(Class<S> serviceClass, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(serviceClass)).load(loader);
    }

    public static <S> S load(Class<S> serviceClass) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(serviceClass)).load(EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> serviceClass, String activateName) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(serviceClass)).load(activateName, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(service)).load(activateName, loader);
    }

    public static <S> S load(Class<S> serviceClass, String activateName, Object[] args) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(serviceClass)).load(activateName, args, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> serviceClass, String activateName, Class<?>[] argsType, Object[] args) throws EnhancedServiceNotFoundException {
        return (S)((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(serviceClass)).load(activateName, argsType, args, EnhancedServiceLoader.findClassLoader());
    }

    @NonNull
    public static <S> List<S> loadAll(Class<S> serviceClass) {
        return ((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(serviceClass)).loadAll(EnhancedServiceLoader.findClassLoader());
    }

    public static <S> List<S> loadAll(Class<S> serviceClass, Class<?>[] argsType, Object[] args) {
        return ((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(serviceClass)).loadAll(argsType, args, EnhancedServiceLoader.findClassLoader());
    }

    public static void unloadAll() {
        InnerEnhancedServiceLoader.removeAllServiceLoader();
    }

    public static <S> void unload(Class<S> service) {
        InnerEnhancedServiceLoader.removeServiceLoader(service);
    }

    public static <S> void unload(Class<S> service, String activateName) {
        if (activateName == null) {
            throw new IllegalArgumentException("activateName is null");
        }
        InnerEnhancedServiceLoader serviceLoader = InnerEnhancedServiceLoader.getServiceLoader(service);
        ConcurrentMap classToDefinitionMap = serviceLoader.classToDefinitionMap;
        ArrayList extensionDefinitions = new ArrayList();
        for (Map.Entry entry : classToDefinitionMap.entrySet()) {
            String name = ((ExtensionDefinition)entry.getValue()).getName();
            if (null == name || !name.equals(activateName)) continue;
            extensionDefinitions.add(entry.getValue());
            classToDefinitionMap.remove(entry.getKey());
        }
        serviceLoader.nameToDefinitionsMap.remove(activateName);
        if (!org.springframework.util.CollectionUtils.isEmpty(extensionDefinitions)) {
            for (ExtensionDefinition definition : extensionDefinitions) {
                serviceLoader.definitionToInstanceMap.remove(definition);
            }
        }
    }

    static <S> List<Class<?>> getAllExtensionClass(Class<S> serviceClass) {
        return ((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(serviceClass)).getAllExtensionClass(EnhancedServiceLoader.findClassLoader());
    }

    static <S> List<Class<?>> getAllExtensionClass(Class<S> serviceClass, ClassLoader loader) {
        return ((InnerEnhancedServiceLoader)InnerEnhancedServiceLoader.getServiceLoader(serviceClass)).getAllExtensionClass(loader);
    }

    private static ClassLoader findClassLoader() {
        return EnhancedServiceLoader.class.getClassLoader();
    }

    private static class InnerEnhancedServiceLoader<S> {
        private static final Logger LOGGER = LoggerFactory.getLogger(InnerEnhancedServiceLoader.class);
        private static final String SERVICES_DIRECTORY = "META-INF/services/";
        private static final ConcurrentMap<Class<?>, InnerEnhancedServiceLoader<?>> SERVICE_LOADERS = new ConcurrentHashMap();
        private final Class<S> type;
        private final Holder<List<ExtensionDefinition>> definitionsHolder = new Holder();
        private final ConcurrentMap<ExtensionDefinition, Holder<Object>> definitionToInstanceMap = new ConcurrentHashMap<ExtensionDefinition, Holder<Object>>();
        private final ConcurrentMap<String, List<ExtensionDefinition>> nameToDefinitionsMap = new ConcurrentHashMap<String, List<ExtensionDefinition>>();
        private final ConcurrentMap<Class<?>, ExtensionDefinition> classToDefinitionMap = new ConcurrentHashMap();

        private InnerEnhancedServiceLoader(Class<S> type) {
            this.type = type;
        }

        private static <S> InnerEnhancedServiceLoader<S> getServiceLoader(Class<S> type) {
            if (type == null) {
                throw new IllegalArgumentException("Enhanced Service type is null");
            }
            return MapUtils.computeIfAbsent(SERVICE_LOADERS, type, key -> new InnerEnhancedServiceLoader(type));
        }

        private static <S> InnerEnhancedServiceLoader<S> removeServiceLoader(Class<S> type) {
            if (type == null) {
                throw new IllegalArgumentException("Enhanced Service type is null");
            }
            return (InnerEnhancedServiceLoader)SERVICE_LOADERS.remove(type);
        }

        private static void removeAllServiceLoader() {
            SERVICE_LOADERS.clear();
        }

        private S load(ClassLoader loader) throws EnhancedServiceNotFoundException {
            return this.loadExtension(loader, null, null);
        }

        private S load(String activateName, ClassLoader loader) throws EnhancedServiceNotFoundException {
            return this.loadExtension(activateName, loader, null, null);
        }

        private S load(String activateName, Object[] args, ClassLoader loader) throws EnhancedServiceNotFoundException {
            Class[] argsType = null;
            if (args != null && args.length > 0) {
                argsType = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argsType[i] = args[i].getClass();
                }
            }
            return this.loadExtension(activateName, loader, argsType, args);
        }

        private S load(String activateName, Class<?>[] argsType, Object[] args, ClassLoader loader) throws EnhancedServiceNotFoundException {
            return this.loadExtension(activateName, loader, argsType, args);
        }

        @NonNull
        private List<S> loadAll(ClassLoader loader) {
            return this.loadAll(null, null, loader);
        }

        @NonNull
        private List<S> loadAll(Class<?>[] argsType, Object[] args, ClassLoader loader) {
            ArrayList<S> allInstances = new ArrayList<S>();
            List<Class<?>> allClasses = this.getAllExtensionClass(loader);
            if (org.springframework.util.CollectionUtils.isEmpty(allClasses)) {
                return allInstances;
            }
            try {
                for (Class<?> clazz : allClasses) {
                    ExtensionDefinition definition = (ExtensionDefinition)this.classToDefinitionMap.get(clazz);
                    allInstances.add(this.getExtensionInstance(definition, loader, argsType, args));
                }
            }
            catch (EnhancedServiceNotFoundException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EnhancedServiceNotFoundException("get extension instance failed", e);
            }
            return allInstances;
        }

        private List<Class<?>> getAllExtensionClass(ClassLoader loader) {
            return this.loadAllExtensionClass(loader);
        }

        private S loadExtension(ClassLoader loader, Class<?>[] argTypes, Object[] args) {
            try {
                this.loadAllExtensionClass(loader);
                ExtensionDefinition defaultExtensionDefinition = this.getDefaultExtensionDefinition();
                return this.getExtensionInstance(defaultExtensionDefinition, loader, argTypes, args);
            }
            catch (EnhancedServiceNotFoundException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EnhancedServiceNotFoundException("not found service provider for: " + this.type.getName(), e);
            }
        }

        private S loadExtension(String activateName, ClassLoader loader, Class<?>[] argTypes, Object[] args) {
            if (StringUtils.isEmpty((Object)activateName)) {
                throw new IllegalArgumentException("the name of service provider for [" + this.type.getName() + "] name is null");
            }
            try {
                this.loadAllExtensionClass(loader);
                ExtensionDefinition cachedExtensionDefinition = this.getCachedExtensionDefinition(activateName);
                return this.getExtensionInstance(cachedExtensionDefinition, loader, argTypes, args);
            }
            catch (EnhancedServiceNotFoundException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EnhancedServiceNotFoundException("not found service provider for: " + this.type.getName(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private S getExtensionInstance(ExtensionDefinition definition, ClassLoader loader, Class<?>[] argTypes, Object[] args) {
            if (definition == null) {
                throw new EnhancedServiceNotFoundException("not found service provider for : " + this.type.getName());
            }
            if (Scope.SINGLETON.equals((Object)definition.getScope())) {
                Holder holder = MapUtils.computeIfAbsent(this.definitionToInstanceMap, definition, key -> new Holder());
                Object instance = holder.get();
                if (instance == null) {
                    Holder holder2 = holder;
                    synchronized (holder2) {
                        instance = holder.get();
                        if (instance == null) {
                            instance = this.createNewExtension(definition, loader, argTypes, args);
                            holder.set(instance);
                        }
                    }
                }
                return (S)instance;
            }
            return this.createNewExtension(definition, loader, argTypes, args);
        }

        private S createNewExtension(ExtensionDefinition definition, ClassLoader loader, Class<?>[] argTypes, Object[] args) {
            Class<?> clazz = definition.getServiceClass();
            try {
                Object newInstance = this.initInstance(clazz, argTypes, args);
                return (S)newInstance;
            }
            catch (Exception e) {
                throw new IllegalStateException("Extension instance(definition: " + definition + ", class: " + this.type + ")  could not be instantiated: " + e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Class<?>> loadAllExtensionClass(ClassLoader loader) {
            List<ExtensionDefinition> definitions = (List<ExtensionDefinition>)((Holder)this.definitionsHolder).get();
            if (definitions == null) {
                Holder<List<ExtensionDefinition>> holder = this.definitionsHolder;
                synchronized (holder) {
                    definitions = (List)((Holder)this.definitionsHolder).get();
                    if (definitions == null) {
                        definitions = this.findAllExtensionDefinition(loader);
                        ((Holder)this.definitionsHolder).set(definitions);
                    }
                }
            }
            return definitions.stream().map(ExtensionDefinition::getServiceClass).collect(Collectors.toList());
        }

        private List<ExtensionDefinition> findAllExtensionDefinition(ClassLoader loader) {
            ArrayList<ExtensionDefinition> extensionDefinitions = new ArrayList<ExtensionDefinition>();
            try {
                this.loadFile(SERVICES_DIRECTORY, loader, extensionDefinitions);
            }
            catch (IOException e) {
                throw new EnhancedServiceNotFoundException(e);
            }
            if (!this.nameToDefinitionsMap.isEmpty()) {
                for (List definitions : this.nameToDefinitionsMap.values()) {
                    definitions.sort((def1, def2) -> {
                        int o1 = def1.getOrder();
                        int o2 = def2.getOrder();
                        return Integer.compare(o1, o2);
                    });
                }
            }
            if (!extensionDefinitions.isEmpty()) {
                extensionDefinitions.sort((definition1, definition2) -> {
                    int o1 = definition1.getOrder();
                    int o2 = definition2.getOrder();
                    return Integer.compare(o1, o2);
                });
            }
            return extensionDefinitions;
        }

        private void loadFile(String dir, ClassLoader loader, List<ExtensionDefinition> extensions) throws IOException {
            String fileName = dir + this.type.getName();
            Enumeration<URL> urls = loader != null ? loader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null) {
                block22: while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    try {
                        InputStreamReader isr = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
                        Throwable throwable = null;
                        try {
                            BufferedReader reader = new BufferedReader(isr);
                            Throwable throwable2 = null;
                            block23: while (true) {
                                try {
                                    String line;
                                    while ((line = reader.readLine()) != null) {
                                        int ci = line.indexOf(35);
                                        if (ci >= 0) {
                                            line = line.substring(0, ci);
                                        }
                                        if ((line = line.trim()).length() <= 0) continue;
                                        try {
                                            ExtensionDefinition extensionDefinition = this.getUnloadedExtensionDefinition(line, loader);
                                            if (extensionDefinition == null) {
                                                if (!LOGGER.isDebugEnabled()) continue block23;
                                                LOGGER.debug("The same extension {} has already been loaded, skipped", (Object)line);
                                                continue;
                                            }
                                            extensions.add(extensionDefinition);
                                            continue block23;
                                        }
                                        catch (ClassNotFoundException | LinkageError e) {
                                            LOGGER.warn("Load [{}] class fail. {}", (Object)line, (Object)e.getMessage());
                                        }
                                    }
                                    continue block22;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (isr == null) continue;
                            if (throwable != null) {
                                try {
                                    isr.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            isr.close();
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.warn("load clazz instance error: {}", (Object)e.getMessage());
                    }
                }
            }
        }

        private ExtensionDefinition getUnloadedExtensionDefinition(String className, ClassLoader loader) throws ClassNotFoundException {
            if (!this.isDefinitionContainsClazz(className, loader)) {
                Class<?> clazz = Class.forName(className, true, loader);
                String serviceName = null;
                int priority = 0;
                Scope scope = Scope.SINGLETON;
                LoadLevel loadLevel = clazz.getAnnotation(LoadLevel.class);
                if (loadLevel != null) {
                    serviceName = loadLevel.name();
                    priority = loadLevel.order();
                    scope = loadLevel.scope();
                }
                ExtensionDefinition result = new ExtensionDefinition(serviceName, priority, scope, clazz);
                this.classToDefinitionMap.put(clazz, result);
                if (serviceName != null) {
                    MapUtils.computeIfAbsent(this.nameToDefinitionsMap, serviceName, e -> new ArrayList()).add(result);
                }
                return result;
            }
            return null;
        }

        private boolean isDefinitionContainsClazz(String className, ClassLoader loader) {
            for (Map.Entry entry : this.classToDefinitionMap.entrySet()) {
                if (!((Class)entry.getKey()).getName().equals(className) || !Objects.equals(((ExtensionDefinition)entry.getValue()).getServiceClass().getClassLoader(), loader)) continue;
                return true;
            }
            return false;
        }

        private ExtensionDefinition getDefaultExtensionDefinition() {
            List currentDefinitions = (List)((Holder)this.definitionsHolder).get();
            return (ExtensionDefinition)CollectionUtils.getLast(currentDefinitions);
        }

        private ExtensionDefinition getCachedExtensionDefinition(String activateName) {
            List definitions = (List)this.nameToDefinitionsMap.get(activateName);
            return (ExtensionDefinition)CollectionUtils.getLast(definitions);
        }

        private S initInstance(Class<S> implClazz, Class<?>[] argTypes, Object[] args) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            S s;
            if (argTypes != null && args != null) {
                Constructor<S> constructor = implClazz.getDeclaredConstructor(argTypes);
                s = this.type.cast(constructor.newInstance(args));
            } else {
                s = this.type.cast(implClazz.newInstance());
            }
            if (s instanceof Initialize) {
                ((Initialize)s).init();
            }
            return s;
        }

        private static class Holder<T> {
            private volatile T value;

            private Holder() {
            }

            private void set(T value) {
                this.value = value;
            }

            private T get() {
                return this.value;
            }
        }
    }
}

