/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.enums.DateFormatType;
import icu.easyj.core.util.DateFormatFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class DateUtils {
    public static Date getDate(Date time) {
        return new Date(time.getYear(), time.getMonth(), time.getDate());
    }

    @NonNull
    public static Date getTomorrowDate(@NonNull Date time) {
        return DateUtils.getDate(new Date(time.getTime() + 86400000L));
    }

    @NonNull
    public static Date parse(@NonNull String str, @NonNull DateFormatType format) throws ParseException {
        SimpleDateFormat sdf = DateFormatFactory.get(format);
        return sdf.parse(str);
    }

    @NonNull
    public static Date parse(@NonNull String str, @NonNull String format) throws ParseException {
        SimpleDateFormat sdf = DateFormatFactory.get(format);
        return sdf.parse(str);
    }

    @NonNull
    public static Date parseMonth(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MM);
    }

    @NonNull
    public static Date parseDate(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.DD);
    }

    @NonNull
    public static Date parseMinutes(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MI);
    }

    @NonNull
    public static Date parseSeconds(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SS);
    }

    @NonNull
    public static Date parseMillisecond(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SSS);
    }

    @NonNull
    public static Date parseMonth2(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MM2);
    }

    @NonNull
    public static Date parseDate2(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.DD2);
    }

    public static Date parseMinutes2(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MI2);
    }

    @NonNull
    public static Date parseSeconds2(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SS2);
    }

    @NonNull
    public static Date parseMillisecond2(String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SSS2);
    }

    @NonNull
    public static Date parseMonth3(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MM3);
    }

    @NonNull
    public static Date parseDate3(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.DD3);
    }

    @NonNull
    public static Date parseMonthUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MM_UNSIGNED);
    }

    @NonNull
    public static Date parseDateUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.DD_UNSIGNED);
    }

    @NonNull
    public static Date parseMinutesUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MI_UNSIGNED);
    }

    @NonNull
    public static Date parseSecondsUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SS_UNSIGNED);
    }

    @NonNull
    public static Date parseMillisecondUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SSS_UNSIGNED);
    }

    @NonNull
    public static Date parseAll(@NonNull String timeStr) {
        Assert.notNull((Object)timeStr, (String)"'timeStr' must be not null");
        try {
            switch (timeStr.length()) {
                case 7: {
                    if (timeStr.contains("-")) {
                        return DateUtils.parseMonth(timeStr);
                    }
                    if (timeStr.contains("/")) {
                        return DateUtils.parseMonth2(timeStr);
                    }
                    return DateUtils.parseMonth3(timeStr);
                }
                case 10: {
                    if (timeStr.contains("-")) {
                        return DateUtils.parseDate(timeStr);
                    }
                    if (timeStr.contains("/")) {
                        return DateUtils.parseDate2(timeStr);
                    }
                    return DateUtils.parseDate3(timeStr);
                }
                case 16: {
                    if (timeStr.contains("-")) {
                        return DateUtils.parseMinutes(timeStr);
                    }
                    return DateUtils.parseSeconds2(timeStr);
                }
                case 19: {
                    if (timeStr.contains("-")) {
                        return DateUtils.parseSeconds(timeStr);
                    }
                    return DateUtils.parseMinutes2(timeStr);
                }
                case 23: {
                    if (timeStr.contains("-")) {
                        return DateUtils.parseMillisecond(timeStr);
                    }
                    return DateUtils.parseMillisecond2(timeStr);
                }
                case 6: {
                    return DateUtils.parseMonthUnsigned(timeStr);
                }
                case 8: {
                    return DateUtils.parseDateUnsigned(timeStr);
                }
                case 12: {
                    return DateUtils.parseMinutesUnsigned(timeStr);
                }
                case 14: {
                    return DateUtils.parseSecondsUnsigned(timeStr);
                }
                case 17: {
                    return DateUtils.parseMillisecondUnsigned(timeStr);
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return new Date(timeStr);
    }

    @NonNull
    public static String format(@NonNull String dateFormat, @NonNull Date date) {
        Assert.notNull((Object)dateFormat, (String)"'dateFormat' must be not null");
        Assert.notNull((Object)date, (String)"'date' must be not null");
        return DateFormatFactory.get(dateFormat).format(date);
    }

    @NonNull
    public static String format(@NonNull DateFormatType dateFormat, @NonNull Date date) {
        Assert.notNull((Object)((Object)dateFormat), (String)"'dateFormat' must be not null");
        Assert.notNull((Object)date, (String)"'date' must be not null");
        return DateFormatFactory.get(dateFormat).format(date);
    }

    @NonNull
    public static String toString(@Nullable Date date) {
        if (date == null) {
            return "null";
        }
        long time = date.getTime();
        DateFormatType dateFormat = date.getHours() == 0 && date.getMinutes() == 0 && date.getSeconds() == 0 && time % 1000L == 0L ? DateFormatType.DD : (time % 60000L == 0L ? DateFormatType.MI : (time % 1000L == 0L ? DateFormatType.SS : DateFormatType.SSS));
        return DateUtils.format(dateFormat, date);
    }
}

