/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import cn.hutool.core.io.IORuntimeException;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.lang.NonNull;

public abstract class ResourceUtils {
    private static final ResourcePatternResolver RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver();

    @NonNull
    public static Resource[] getResources(String locationPattern) {
        try {
            return RESOURCE_RESOLVER.getResources(locationPattern);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    @NonNull
    public static Resource[] getResources(String ... locationPatternArr) {
        return (Resource[])Stream.of((Object[])Optional.ofNullable(locationPatternArr).orElse(new String[0])).flatMap(locationPattern -> Stream.of(ResourceUtils.getResources(locationPattern))).toArray(Resource[]::new);
    }

    @NonNull
    public static String getResourceUri(@NonNull Resource resource) {
        try {
            return resource.getURI().toString();
        }
        catch (IOException e) {
            throw new IORuntimeException("\u83b7\u53d6\u8d44\u6e90\u8def\u5f84\u5931\u8d25", (Throwable)e);
        }
    }
}

