/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.CycleDependencyHandler;
import icu.easyj.core.util.DateUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class StringUtils {
    public static final int CASE_DIFF = 32;

    public static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static int chineseLength(String str) {
        if (str == null || str.isEmpty()) {
            return 0;
        }
        int length = str.length();
        for (char c : str.toCharArray()) {
            if (!StringUtils.isChinese(c)) continue;
            ++length;
        }
        return length;
    }

    @Nullable
    public static String find(String[] strArr, Predicate<String> matcher) {
        for (String str : strArr) {
            if (!matcher.test(str)) continue;
            return str;
        }
        return null;
    }

    @Nullable
    public static String findNotEmptyOne(String ... strArr) {
        return StringUtils.find(strArr, org.springframework.util.StringUtils::hasLength);
    }

    @Nullable
    public static String findNotBlankOne(String ... strArr) {
        return StringUtils.find(strArr, org.springframework.util.StringUtils::hasText);
    }

    @NonNull
    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            return "\"" + obj + "\"";
        }
        if (obj instanceof Character) {
            return "'" + obj + "'";
        }
        if (obj instanceof Long) {
            return obj + "L";
        }
        if (obj instanceof Date) {
            return DateUtils.toString((Date)obj);
        }
        if (obj instanceof Enum) {
            return obj.getClass().getSimpleName() + "." + ((Enum)obj).name();
        }
        if (obj instanceof Class) {
            return ReflectionUtils.classToString((Class)obj);
        }
        if (obj instanceof Field) {
            return ReflectionUtils.fieldToString((Field)obj);
        }
        if (obj instanceof Method) {
            return ReflectionUtils.methodToString((Method)obj);
        }
        if (obj instanceof Annotation) {
            return ReflectionUtils.annotationToString((Annotation)obj);
        }
        if (obj instanceof Collection) {
            return CollectionUtils.toString((Collection)obj);
        }
        if (obj.getClass().isArray()) {
            return ArrayUtils.toString((Object[])obj);
        }
        if (obj instanceof Map) {
            return MapUtils.toString((Map)obj);
        }
        if (obj.getClass().getClassLoader() == null) {
            return obj.toString();
        }
        return StringUtils.unknownTypeObjectToString(obj);
    }

    @NonNull
    private static String unknownTypeObjectToString(@NonNull Object obj) {
        return CycleDependencyHandler.wrap(obj, o -> {
            Field[] fields;
            String classSimpleName;
            StringBuilder sb = new StringBuilder(32);
            if (obj.getClass().isAnonymousClass()) {
                classSimpleName = !obj.getClass().getSuperclass().equals(Object.class) ? obj.getClass().getSuperclass().getSimpleName() : obj.getClass().getInterfaces()[0].getSimpleName();
                classSimpleName = classSimpleName + "$";
            } else {
                classSimpleName = obj.getClass().getSimpleName();
            }
            sb.append(classSimpleName).append("(");
            int initialLength = sb.length();
            for (Field field : fields = ReflectionUtils.getAllFields(obj.getClass())) {
                Object fieldValue;
                if (sb.length() > initialLength) {
                    sb.append(", ");
                }
                sb.append(field.getName());
                sb.append("=");
                try {
                    fieldValue = ReflectionUtils.getFieldValue(obj, field);
                }
                catch (RuntimeException ignore) {
                    continue;
                }
                if (fieldValue == obj) {
                    sb.append("(this ").append(fieldValue.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(StringUtils.toString(fieldValue));
            }
            sb.append(")");
            return sb.toString();
        });
    }
}

