/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.crypto;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.springframework.lang.Nullable;

public interface ICrypto
extends Serializable {
    public String getAlgorithm();

    @Nullable
    public byte[] encrypt(@Nullable byte[] var1);

    default public byte[] encrypt(String data) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)CharsetUtil.CHARSET_UTF_8));
    }

    default public byte[] encrypt(String data, Charset charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)charset));
    }

    default public byte[] encrypt(String data, String charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (String)charset));
    }

    default public byte[] encrypt(InputStream data) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes((InputStream)data));
    }

    default public String encryptHex(byte[] data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }

    default public String encryptHex(String data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }

    default public String encryptHex(String data, Charset charset) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset));
    }

    default public String encryptHex(String data, String charset) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset));
    }

    default public String encryptHex(InputStream data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }

    default public String encryptBase64(byte[] data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    default public String encryptBase64(String data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    default public String encryptBase64(String data, Charset charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    default public String encryptBase64(String data, String charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    default public String encryptBase64(InputStream data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    default public String encryptBcd(byte[] data) {
        return BCD.bcdToStr((byte[])this.encrypt(data));
    }

    default public String encryptBcd(String data) {
        return this.encryptBcd(data, CharsetUtil.CHARSET_UTF_8);
    }

    default public String encryptBcd(String data, Charset charset) {
        return BCD.bcdToStr((byte[])this.encrypt(data, charset));
    }

    default public String encryptBcd(String data, String charset) {
        return BCD.bcdToStr((byte[])this.encrypt(data, charset));
    }

    default public String encryptBcd(InputStream data) {
        return BCD.bcdToStr((byte[])this.encrypt(data));
    }

    @Nullable
    public byte[] decrypt(@Nullable byte[] var1);

    default public byte[] decrypt(String data) {
        return this.decrypt(SecureUtil.decode((String)data));
    }

    default public byte[] decrypt(InputStream data) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes((InputStream)data));
    }

    default public String decryptStr(byte[] bytes, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(bytes), (Charset)charset);
    }

    default public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, CharsetUtil.CHARSET_UTF_8);
    }

    default public String decryptStr(InputStream data, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(data), (Charset)charset);
    }

    default public String decryptStr(InputStream data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    default public String decryptStr(String data, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(data), (Charset)charset);
    }

    default public String decryptStr(String data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    default public String decryptBase64(String data, Charset charset) {
        return this.decryptStr(Base64.decode((CharSequence)data), charset);
    }

    default public String decryptBase64(String data) {
        return this.decryptBase64(data, CharsetUtil.CHARSET_UTF_8);
    }

    default public String decryptHex(String data, Charset charset) {
        return this.decryptStr(HexUtil.decodeHex((String)data), charset);
    }

    default public String decryptHex(String data) {
        return this.decryptHex(data, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decryptFromBcd(String data) {
        return this.decryptFromBcd(data, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decryptFromBcd(String data, Charset charset) {
        Assert.notNull((Object)data, (String)"'data' must be not null", (Object[])new Object[0]);
        byte[] dataBytes = BCD.ascToBcd((byte[])StrUtil.bytes((CharSequence)data, (Charset)charset));
        return this.decrypt(dataBytes);
    }

    default public String decryptStrFromBcd(String data, Charset charset) {
        return StrUtil.str((byte[])this.decryptFromBcd(data, charset), (Charset)charset);
    }

    default public String decryptStrFromBcd(String data) {
        return this.decryptStrFromBcd(data, CharsetUtil.CHARSET_UTF_8);
    }
}

