/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.data.memory.querier;

import icu.easyj.data.memory.querier.Pageable;
import icu.easyj.data.memory.querier.Querier;
import icu.easyj.data.memory.querier.SortOrder;
import icu.easyj.data.memory.querier.SortParam;
import icu.easyj.data.memory.querier.Sortable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

public abstract class AbstractQuerier<T>
implements Querier<T>,
Sortable,
Pageable {
    protected SortParam[] sortParams;
    protected int pageNumber = 1;
    protected int pageSize = 10;

    public abstract <D extends T> int compareByFieldName(D var1, D var2, String var3);

    @Override
    @NonNull
    public <D extends T> List<D> doSort(List<D> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList();
        }
        if (!this.isNeedSort(list)) {
            return list;
        }
        list.sort((a, b) -> {
            for (SortParam sortParam : this.getSortParams()) {
                int ret = this.compareByFieldName(a, b, sortParam.getSortFieldName());
                if (ret == 0) continue;
                if (sortParam.getSortOrder() == SortOrder.DESC) {
                    ret = ret > 0 ? -1 : 1;
                }
                return ret;
            }
            return 0;
        });
        return list;
    }

    @Override
    public <D extends T> List<D> doPaging(List<D> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (list.isEmpty() || this.getPageSize() <= 0) {
            return list;
        }
        int fromIndex = this.getFromIndex();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= list.size()) {
            return Collections.emptyList();
        }
        int toIndex = this.getToIndex(fromIndex);
        if (toIndex > list.size()) {
            toIndex = list.size();
        }
        return list.subList(fromIndex, toIndex);
    }

    public int getFromIndex() {
        return (this.pageNumber - 1) * this.pageSize;
    }

    public int getToIndex(int fromIndex) {
        return fromIndex + this.pageSize;
    }

    @Override
    public SortParam[] getSortParams() {
        return this.sortParams;
    }

    @Override
    public void setSortParams(SortParam ... sortParams) {
        this.sortParams = sortParams;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

