/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.clock.factory;

import icu.easyj.core.clock.ITickClock;
import icu.easyj.core.clock.factory.IRemotingClockFactory;
import icu.easyj.core.util.MapUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class AbstractRemotingClockFactory<K>
implements IRemotingClockFactory<K> {
    private final Map<K, ITickClock> remotingClockMap;

    protected AbstractRemotingClockFactory() {
        this(new ConcurrentHashMap(2));
    }

    protected AbstractRemotingClockFactory(Map<K, ITickClock> remotingClockMap) {
        this.remotingClockMap = remotingClockMap;
    }

    @Override
    @NonNull
    public ITickClock getClock(@NonNull K remotingKey) {
        Assert.notNull(remotingKey, (String)"'remotingKey' must not be null");
        return MapUtils.computeIfAbsent(this.remotingClockMap, remotingKey, ds -> this.createClock(remotingKey));
    }

    @Override
    @NonNull
    public ITickClock refreshClock(@NonNull K remotingKey) {
        Assert.notNull(remotingKey, (String)"'remotingKey' must not be null");
        ITickClock newClock = this.createClock(remotingKey);
        this.remotingClockMap.put(remotingKey, newClock);
        return newClock;
    }
}

