/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.enums;

import icu.easyj.core.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;

public enum DataType {
    STRING(11, String.class, "String"),
    CHAR_PRIMITIVE(12, Character.TYPE, "char"),
    CHARACTER(13, Character.class, "Character", "Char"),
    SHORT_PRIMITIVE(21, Short.TYPE, "short"),
    SHORT(22, Short.class, "Short"),
    INT_PRIMITIVE(23, Integer.TYPE, "int"),
    INTEGER(24, Integer.class, "Integer", "Int"),
    LONG_PRIMITIVE(25, Long.TYPE, "long"),
    LONG(26, Long.class, "Long"),
    BIG_INTEGER(27, BigInteger.class, "BigInteger"),
    FLOAT_PRIMITIVE(31, Float.TYPE, "float"),
    FLOAT(32, Float.class, "Float"),
    DOUBLE_PRIMITIVE(33, Double.TYPE, "double"),
    DOUBLE(34, Double.class, "Double"),
    BIG_DECIMAL(35, BigDecimal.class, "decimal", "BigDecimal"),
    BOOLEAN_PRIMITIVE(41, Boolean.TYPE, "boolean", "bool"),
    BOOLEAN(42, Boolean.class, "Boolean"),
    BYTE_PRIMITIVE(51, Byte.TYPE, "byte"),
    BYTE(52, Byte.class, "Byte"),
    DATE(61, Date.class, "Date", "date"),
    DURATION(62, Duration.class, "Duration", "duration");

    private final int code;
    private final Class<?> clazz;
    private final TypeDescriptor typeDesc;
    private final Set<String> types;

    private DataType(int code, Class<?> clazz, String ... types) {
        this.code = code;
        this.clazz = clazz;
        this.typeDesc = TypeDescriptor.valueOf(clazz);
        this.types = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(types)));
    }

    public int getCode() {
        return this.code;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public TypeDescriptor getTypeDesc() {
        return this.typeDesc;
    }

    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    @Nullable
    public static DataType getByCode(int code) {
        if (code <= 0) {
            return null;
        }
        for (DataType dataType : DataType.values()) {
            if (dataType.code != code) continue;
            return dataType;
        }
        return null;
    }

    @Nullable
    public static DataType getByType(String type) {
        if (StringUtils.isEmpty(type)) {
            return null;
        }
        for (DataType dataType : DataType.values()) {
            if (!dataType.clazz.getName().equals(type) && !dataType.types.contains(type)) continue;
            return dataType;
        }
        for (DataType dataType : DataType.values()) {
            for (String tp : dataType.types) {
                if (!tp.equalsIgnoreCase(type)) continue;
                return dataType;
            }
        }
        return null;
    }

    @Nullable
    public static DataType getByClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (DataType dataType : DataType.values()) {
            if (!dataType.clazz.equals(clazz)) continue;
            return dataType;
        }
        return null;
    }
}

