/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import cn.hutool.core.lang.Assert;
import icu.easyj.core.enums.DateFormatType;
import icu.easyj.core.util.MapUtils;
import java.text.SimpleDateFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.NonNull;

public abstract class DateFormatFactory {
    public static final ThreadLocal<Map<String, SimpleDateFormat>> DATE_FORMAT = ThreadLocal.withInitial(HashMap::new);
    public static final ThreadLocal<EnumMap<DateFormatType, SimpleDateFormat>> FREQUENTLY_USED_DATE_FORMAT = ThreadLocal.withInitial(() -> new EnumMap(DateFormatType.class));

    @NonNull
    public static SimpleDateFormat get(@NonNull String dateFormat) {
        Assert.notNull((Object)dateFormat, (String)"'dateFormat' must not be null", (Object[])new Object[0]);
        Map<String, SimpleDateFormat> dateFormatMap = DATE_FORMAT.get();
        return MapUtils.computeIfAbsent(dateFormatMap, dateFormat, f -> new SimpleDateFormat(dateFormat));
    }

    @NonNull
    public static SimpleDateFormat get(@NonNull DateFormatType dateFormat) {
        Assert.notNull((Object)((Object)dateFormat), (String)"'dateFormat' must not be null", (Object[])new Object[0]);
        Map dateFormatMap = FREQUENTLY_USED_DATE_FORMAT.get();
        return MapUtils.computeIfAbsent(dateFormatMap, dateFormat, f -> new SimpleDateFormat(dateFormat.getFormat()));
    }
}

