/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.StringUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public abstract class ObjectUtils {
    public static <T> T defaultIfNull(T obj, T defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj;
    }

    public static <T> T defaultIfNull(T obj, Supplier<T> defaultValueSupplier) {
        if (obj == null) {
            return defaultValueSupplier.get();
        }
        return obj;
    }

    public static <T> T defaultIfEmpty(T obj, T defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof CharSequence) {
            return (T)StringUtils.defaultIfEmpty((CharSequence)obj, (CharSequence)defaultValue);
        }
        if (obj instanceof Collection) {
            return (T)CollectionUtils.defaultIfEmpty((Collection)obj, (Collection)defaultValue);
        }
        if (obj instanceof Map) {
            return (T)MapUtils.defaultIfEmpty((Map)obj, (Map)defaultValue);
        }
        if (obj.getClass().isArray() && Array.getLength(obj) == 0) {
            return defaultValue;
        }
        return obj;
    }

    public static <T> T defaultIfEmpty(T obj, Supplier<T> defaultValueSupplier) {
        if (obj == null || obj instanceof CharSequence && StringUtils.isEmpty((CharSequence)obj) || obj instanceof Collection && CollectionUtils.isEmpty((Collection)obj) || obj instanceof Map && MapUtils.isEmpty((Map)obj) || obj.getClass().isArray() && Array.getLength(obj) == 0) {
            return defaultValueSupplier.get();
        }
        return obj;
    }
}

