/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.StringUtils;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class PerformanceTestUtils {
    @SafeVarargs
    @NonNull
    public static long[] execute(int sets, int times, Supplier<String> ... suppliers) {
        Assert.isTrue((sets > 0 ? 1 : 0) != 0, (String)"'sets' must be greater than 0");
        Assert.isTrue((times > 0 ? 1 : 0) != 0, (String)"'times' must be greater than 0");
        Assert.isTrue((suppliers != null && suppliers.length > 0 ? 1 : 0) != 0, (String)"'suppliers' must be not empty");
        int i = times * 2;
        while (i-- > 0) {
            for (Supplier<String> supplier : suppliers) {
                supplier.get();
            }
        }
        System.out.println("--------------------------------------------------");
        System.out.println("| \u5f00\u59cb\u8fd0\u884c\u6027\u80fd\u6d4b\u8bd5\uff1a                                 |");
        System.out.println("--------------------------------------------------");
        long[] costs = new long[suppliers.length];
        while (sets-- > 0) {
            for (int y = 0; y < suppliers.length; ++y) {
                int n = y;
                costs[n] = costs[n] + PerformanceTestUtils.executeOne(times, suppliers[y]);
            }
            System.out.println("--------------------------------------------------");
        }
        return costs;
    }

    @SafeVarargs
    @NonNull
    public static long[] execute(int times, Supplier<String> ... suppliers) {
        return PerformanceTestUtils.execute(1, times, suppliers);
    }

    private static long executeOne(int times, Supplier<String> supplier) {
        long startTime = System.nanoTime();
        while (times-- > 1) {
            supplier.get();
        }
        String supplierName = supplier.get();
        long cost = PerformanceTestUtils.getCost(startTime);
        String costStr = String.valueOf(cost);
        System.out.println("| \u51fd\u6570\u540d\uff1a" + org.apache.commons.lang3.StringUtils.rightPad((String)supplierName, (int)(16 + supplierName.length() - StringUtils.chineseLength(supplierName)), (char)' ') + "\u8017\u65f6\uff1a" + org.apache.commons.lang3.StringUtils.leftPad((String)costStr, (int)7, (char)' ') + " ms          |");
        return cost;
    }

    public static long getCost(long startNanoTime) {
        return (System.nanoTime() - startNanoTime) / 1000000L;
    }
}

