/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.CycleDependencyHandler;
import icu.easyj.core.util.DateUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class StringUtils {
    public static final int CASE_DIFF = 32;
    private static final Field STRING_VALUE_FIELD;

    public static char[] toCharArrayWithoutCopy(CharSequence str) {
        try {
            return (char[])STRING_VALUE_FIELD.get(str.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u83b7\u53d6\u5b57\u7b26\u4e32\u7684value\u5931\u8d25", e);
        }
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs == null) {
            return true;
        }
        int length = cs.length();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T cs, T defaultValue) {
        if (StringUtils.isEmpty(cs)) {
            return defaultValue;
        }
        return cs;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T cs, Supplier<T> defaultValueSupplier) {
        if (StringUtils.isEmpty(cs)) {
            return (T)((CharSequence)defaultValueSupplier.get());
        }
        return cs;
    }

    public static <T extends CharSequence> T defaultIfBlank(T cs, T defaultValue) {
        if (StringUtils.isBlank(cs)) {
            return defaultValue;
        }
        return cs;
    }

    public static <T extends CharSequence> T defaultIfBlank(T cs, Supplier<T> defaultValueSupplier) {
        if (StringUtils.isBlank(cs)) {
            return (T)((CharSequence)defaultValueSupplier.get());
        }
        return cs;
    }

    public static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static int chineseLength(CharSequence cs) {
        int length;
        if (StringUtils.isEmpty(cs)) {
            return 0;
        }
        int resultLength = length = cs.length();
        for (int i = 0; i < length; ++i) {
            if (!StringUtils.isChinese(cs.charAt(i))) continue;
            ++resultLength;
        }
        return resultLength;
    }

    @Nullable
    public static String find(String[] strArr, Predicate<String> matcher) {
        for (String str : strArr) {
            if (!matcher.test(str)) continue;
            return str;
        }
        return null;
    }

    @Nullable
    public static String findNotEmptyOne(String ... strArr) {
        return StringUtils.find(strArr, StringUtils::isNotEmpty);
    }

    @Nullable
    public static String findNotBlankOne(String ... strArr) {
        return StringUtils.find(strArr, StringUtils::isNotBlank);
    }

    @NonNull
    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            return "\"" + obj + "\"";
        }
        if (obj instanceof Character) {
            return "'" + obj + "'";
        }
        if (obj instanceof Long) {
            return obj + "L";
        }
        if (obj instanceof Date) {
            return DateUtils.toString((Date)obj);
        }
        if (obj instanceof Enum) {
            return obj.getClass().getSimpleName() + "." + ((Enum)obj).name();
        }
        if (obj instanceof Class) {
            return ReflectionUtils.classToString((Class)obj);
        }
        if (obj instanceof Field) {
            return ReflectionUtils.fieldToString((Field)obj);
        }
        if (obj instanceof Method) {
            return ReflectionUtils.methodToString((Method)obj);
        }
        if (obj instanceof Annotation) {
            return ReflectionUtils.annotationToString((Annotation)obj);
        }
        if (obj instanceof Collection) {
            return CollectionUtils.toString((Collection)obj);
        }
        if (obj.getClass().isArray()) {
            return ArrayUtils.toString((Object[])obj);
        }
        if (obj instanceof Map) {
            return MapUtils.toString((Map)obj);
        }
        if (obj.getClass().getClassLoader() == null) {
            return obj.toString();
        }
        return StringUtils.unknownTypeObjectToString(obj);
    }

    @NonNull
    private static String unknownTypeObjectToString(@NonNull Object obj) {
        return CycleDependencyHandler.wrap(obj, o -> {
            Field[] fields;
            String classSimpleName;
            StringBuilder sb = new StringBuilder(32);
            if (obj.getClass().isAnonymousClass()) {
                classSimpleName = !obj.getClass().getSuperclass().equals(Object.class) ? obj.getClass().getSuperclass().getSimpleName() : obj.getClass().getInterfaces()[0].getSimpleName();
                classSimpleName = classSimpleName + "$";
            } else {
                classSimpleName = obj.getClass().getSimpleName();
            }
            sb.append(classSimpleName).append("(");
            int initialLength = sb.length();
            for (Field field : fields = ReflectionUtils.getAllFields(obj.getClass())) {
                Object fieldValue;
                if (sb.length() > initialLength) {
                    sb.append(", ");
                }
                sb.append(field.getName());
                sb.append("=");
                try {
                    fieldValue = ReflectionUtils.getFieldValue(obj, field);
                }
                catch (RuntimeException ignore) {
                    continue;
                }
                if (fieldValue == obj) {
                    sb.append("(this ").append(fieldValue.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(StringUtils.toString(fieldValue));
            }
            sb.append(")");
            return sb.toString();
        });
    }

    static {
        try {
            STRING_VALUE_FIELD = String.class.getDeclaredField("value");
            STRING_VALUE_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

