/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.CycleDependencyHandler;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class CollectionUtils
extends MapUtils {
    @NonNull
    public static String toString(Collection<?> col) {
        if (col == null) {
            return "null";
        }
        if (col.isEmpty()) {
            return "[]";
        }
        return CycleDependencyHandler.wrap(col, o -> {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[");
            for (Object obj : col) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                if (obj == col) {
                    sb.append("(this ").append(obj.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(StringUtils.toString(obj));
            }
            sb.append("]");
            return sb.toString();
        });
    }

    @Nullable
    public static <T> T getFirst(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        try {
            return list.get(0);
        }
        catch (IndexOutOfBoundsException ignore) {
            return null;
        }
    }

    @Nullable
    public static <T> T getLast(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        int size;
        while ((size = list.size()) != 0) {
            try {
                return list.get(size - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            break;
        }
        return null;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static <T extends Collection<?>> T defaultIfEmpty(T coll, T defaultValue) {
        if (CollectionUtils.isEmpty(coll)) {
            return defaultValue;
        }
        return coll;
    }

    public static <T extends Collection<?>> T defaultIfEmpty(T coll, Supplier<T> defaultValueSupplier) {
        if (CollectionUtils.isEmpty(coll)) {
            return (T)((Collection)defaultValueSupplier.get());
        }
        return coll;
    }
}

