/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.string.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnJavaVersion;
import icu.easyj.core.util.string.IStringService;
import org.springframework.lang.NonNull;

@LoadLevel(name="JDK9~Latest-Base64", order=900)
@DependsOnJavaVersion(min=16.0f)
class Jdk16ToLatestStringServiceImpl
implements IStringService {
    static final byte LATIN1 = 0;
    static final byte UTF16 = 1;

    Jdk16ToLatestStringServiceImpl() {
    }

    @Override
    public char[] toCharArray(@NonNull CharSequence str) {
        return str.toString().toCharArray();
    }

    public char[] getValue(@NonNull CharSequence str) {
        return this.toCharArray(str);
    }

    @Override
    public byte getCoder(@NonNull CharSequence str) {
        char[] chars;
        for (char c : chars = this.toCharArray(str)) {
            if (c <= '\u007f') continue;
            return 1;
        }
        return 0;
    }
}

