/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.string.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnJavaVersion;
import icu.easyj.core.util.string.IStringService;
import icu.easyj.core.util.string.impls.StringReflection;
import java.lang.reflect.InvocationTargetException;
import org.springframework.lang.NonNull;

@LoadLevel(name="JDK9~15-Base64", order=900)
@DependsOnJavaVersion(min=9.0f, max=15.0f)
class Jdk9To15StringServiceImpl
implements IStringService {
    Jdk9To15StringServiceImpl() {
    }

    @Override
    public char[] toCharArray(@NonNull CharSequence str) {
        return str.toString().toCharArray();
    }

    public byte[] getValue(@NonNull CharSequence str) {
        try {
            return (byte[])StringReflection.STRING_VALUE_FIELD.get(str.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u83b7\u53d6\u5b57\u7b26\u4e32\u7684value\u5931\u8d25", e);
        }
    }

    @Override
    public byte getCoder(@NonNull CharSequence str) {
        try {
            return (Byte)StringReflection.GET_STRING_CODER_METHOD.invoke((Object)str.toString(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("\u83b7\u53d6\u5b57\u7b26\u4e32\u7684coder\u5931\u8d25", e);
        }
    }
}

