/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.version;

import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.version.VersionUtils;
import java.io.Serializable;
import org.springframework.lang.NonNull;

public class VersionInfo
implements Comparable<VersionInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String version;
    private final long versionLong;
    private final boolean unknownVersion;
    private final boolean snapshotVersion;

    public VersionInfo(String version) {
        this.unknownVersion = VersionUtils.isUnknownVersion(version);
        this.version = this.unknownVersion ? "UNKNOWN" : version;
        this.versionLong = VersionUtils.toLong(version);
        this.snapshotVersion = VersionUtils.isSnapshotVersion(version);
    }

    @Override
    public int compareTo(VersionInfo otherVersionInfo) {
        if (otherVersionInfo == null) {
            return 1;
        }
        if (this.version.equals(otherVersionInfo.version)) {
            return 0;
        }
        return Long.compare(this.versionLong, otherVersionInfo.getVersionLong());
    }

    @Override
    public int compareTo(String otherVersion) {
        if (StringUtils.isBlank(otherVersion)) {
            return this.unknownVersion ? 0 : 1;
        }
        if (this.version.equals(otherVersion)) {
            return 0;
        }
        long otherVersionLong = VersionUtils.toLong(otherVersion);
        return Long.compare(this.versionLong, otherVersionLong);
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    public long getVersionLong() {
        return this.versionLong;
    }

    public boolean isUnknownVersion() {
        return this.unknownVersion;
    }

    public boolean isSnapshotVersion() {
        return this.snapshotVersion;
    }
}

