/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.version;

import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.version.IncompatibleVersionException;
import icu.easyj.core.util.version.VersionInfo;
import org.springframework.lang.NonNull;

public abstract class VersionUtils {
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    public static final long UNKNOWN_VERSION_LONG = 0L;
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private static final int MAX_PART_SIZE = 5;
    private static final int ONE_PART_LENGTH = 3;

    @NonNull
    public static VersionInfo parse(String version) {
        return new VersionInfo(version);
    }

    public static long toLong(String version) throws IncompatibleVersionException {
        String[] parts;
        if (VersionUtils.isUnknownVersion(version)) {
            return 0L;
        }
        boolean isSnapshotVersion = VersionUtils.isSnapshotVersion(version);
        if (isSnapshotVersion || StringUtils.contains(version, '-')) {
            version = version.substring(0, version.indexOf(45));
        }
        if ((parts = org.apache.commons.lang3.StringUtils.split((String)version.replace('_', '.'), (char)'.')).length > 5) {
            throw new IncompatibleVersionException("\u5f53\u524d\u7248\u672c\u53f7\u90e8\u5206\u6570 [" + parts.length + "] \u8d85\u8fc7\u4e86\u6700\u5927\u503c [" + 5 + "]\uff0c\u4e0d\u517c\u5bb9\u7684\u7248\u672c\u53f7: " + version);
        }
        long versionLong = 0L;
        int i = 1;
        for (String part : parts) {
            if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)part)) {
                versionLong += VersionUtils.calculatePartValue(part, i);
            }
            ++i;
        }
        versionLong *= 10L;
        if (!isSnapshotVersion) {
            ++versionLong;
        }
        return versionLong;
    }

    public static boolean isUnknownVersion(String version) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)version) || UNKNOWN_VERSION.equalsIgnoreCase(version);
    }

    public static boolean isSnapshotVersion(String version) {
        return version != null && version.endsWith(SNAPSHOT_SUFFIX);
    }

    private static long calculatePartValue(String partNumeric, int partIndex) {
        if (StringUtils.isAllZero(partNumeric)) {
            return 0L;
        }
        return Long.parseLong(partNumeric) * Double.valueOf(Math.pow(Math.pow(10.0, 3.0), 5 - partIndex)).longValue();
    }
}

