/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.util;

import icu.easyj.core.clock.ITickClock;
import icu.easyj.core.clock.TickClock;
import icu.easyj.core.clock.factory.AbstractRemotingClockFactory;
import icu.easyj.db.service.DbServiceFactory;
import icu.easyj.db.service.IDbService;
import javax.sql.DataSource;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

final class DbClockFactory
extends AbstractRemotingClockFactory<DataSource> {
    private DbClockFactory() {
    }

    public static DbClockFactory getInstance() {
        return SingletonHolder.INSTANCE.getDbClockFactory();
    }

    @Override
    @NonNull
    public ITickClock createClock(@NonNull DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must not be null");
        IDbService dbService = DbServiceFactory.getDbService(dataSource);
        long currentTimeMillis = dbService.currentTimeMillis();
        return new TickClock(currentTimeMillis * 1000L);
    }

    private static enum SingletonHolder {
        INSTANCE;

        private final DbClockFactory dbClockFactory = new DbClockFactory();

        public DbClockFactory getDbClockFactory() {
            return this.dbClockFactory;
        }
    }
}

