/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.util;

import icu.easyj.core.util.MapUtils;
import icu.easyj.db.exception.DbException;
import icu.easyj.db.service.DbServiceFactory;
import icu.easyj.db.service.IDbService;
import icu.easyj.db.util.PrimaryDataSourceHolder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class DbUtils {
    private static final ConcurrentHashMap<DataSource, String> DB_TYPE_MAP = new ConcurrentHashMap();

    @NonNull
    private static String convertDbType(String dbType) {
        if ("microsoft sql server".equalsIgnoreCase(dbType)) {
            return "ms_sql_server";
        }
        return dbType;
    }

    @NonNull
    public static String getDbType(@NonNull DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must not be null");
        return MapUtils.computeIfAbsent(DB_TYPE_MAP, dataSource, ds -> {
            try (Connection con = dataSource.getConnection();){
                DatabaseMetaData metaData = con.getMetaData();
                String string = DbUtils.convertDbType(metaData.getDatabaseProductName().toLowerCase());
                return string;
            }
            catch (SQLException e) {
                throw new DbException("\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25", e);
            }
        });
    }

    @NonNull
    public static String getDbVersion(@NonNull DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must not be null");
        IDbService dbService = DbServiceFactory.getDbService(dataSource);
        return dbService.getVersion();
    }

    @NonNull
    public static String getDbType() {
        return DbUtils.getDbType(PrimaryDataSourceHolder.get());
    }

    @NonNull
    public static String getDbVersion() {
        return DbUtils.getDbVersion(PrimaryDataSourceHolder.get());
    }
}

