/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.CycleDependencyHandler;
import icu.easyj.core.util.DateUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.ObjectUtils;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.string.IStringService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class StringUtils {
    private static final IStringService STRING_SERVICE = EnhancedServiceLoader.load(IStringService.class);
    public static final byte CASE_DIFF = 32;

    public static Object getValue(@NonNull CharSequence str) {
        Assert.notNull((Object)str, (String)"'str' must not be null");
        return STRING_SERVICE.getValue(str);
    }

    public static byte getCoder(@NonNull CharSequence str) {
        Assert.notNull((Object)str, (String)"'str' must not be null");
        return STRING_SERVICE.getCoder(str);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs == null) {
            return true;
        }
        int length = cs.length();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isAll(String str, char targetChar) {
        char[] chars;
        if (str == null) {
            return false;
        }
        for (char c : chars = StringUtils.toCharArray(str)) {
            if (c == targetChar) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllZero(String str) {
        return StringUtils.isAll(str, '0');
    }

    public static boolean contains(CharSequence str, char targetChar) {
        char[] chars;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (char c : chars = StringUtils.toCharArray(str)) {
            if (c != targetChar) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T cs, T defaultValue) {
        if (StringUtils.isEmpty(cs)) {
            return defaultValue;
        }
        return cs;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T cs, Supplier<T> defaultValueSupplier) {
        if (StringUtils.isEmpty(cs)) {
            return (T)((CharSequence)defaultValueSupplier.get());
        }
        return cs;
    }

    public static <T extends CharSequence> T defaultIfBlank(T cs, T defaultValue) {
        if (StringUtils.isBlank(cs)) {
            return defaultValue;
        }
        return cs;
    }

    public static <T extends CharSequence> T defaultIfBlank(T cs, Supplier<T> defaultValueSupplier) {
        if (StringUtils.isBlank(cs)) {
            return (T)((CharSequence)defaultValueSupplier.get());
        }
        return cs;
    }

    public static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static int chineseLength(CharSequence cs) {
        int length;
        if (StringUtils.isEmpty(cs)) {
            return 0;
        }
        int resultLength = length = cs.length();
        for (int i = 0; i < length; ++i) {
            if (!StringUtils.isChinese(cs.charAt(i))) continue;
            ++resultLength;
        }
        return resultLength;
    }

    @Nullable
    public static String findNotEmptyOne(String ... strArr) {
        return ObjectUtils.find(strArr, StringUtils::isNotEmpty);
    }

    @Nullable
    public static String findNotBlankOne(String ... strArr) {
        return ObjectUtils.find(strArr, StringUtils::isNotBlank);
    }

    public static String trim(@NonNull String str, char cutChar) {
        int start;
        Assert.notNull((Object)str, (String)"'str' must not be null");
        int end = str.length();
        char[] chars = StringUtils.toCharArray(str);
        for (start = 0; start < end && StringUtils.isCutCharOrBlank(chars[start], cutChar); ++start) {
        }
        if (start == end) {
            return "";
        }
        while (end > start && StringUtils.isCutCharOrBlank(chars[end - 1], cutChar)) {
            --end;
        }
        if (start > 0 || end < str.length()) {
            return str.substring(start, end);
        }
        return str;
    }

    public static String trimStart(@NonNull String str, char cutChar) {
        int start;
        Assert.notNull((Object)str, (String)"'str' must not be null");
        int end = str.length();
        char[] chars = StringUtils.toCharArray(str);
        for (start = 0; start < end && StringUtils.isCutCharOrBlank(chars[start], cutChar); ++start) {
        }
        if (start == end) {
            return "";
        }
        if (start > 0) {
            return str.substring(start, end);
        }
        return str;
    }

    public static String trimEnd(@NonNull String str, char cutChar) {
        int end;
        Assert.notNull((Object)str, (String)"'str' must not be null");
        int start = 0;
        char[] chars = StringUtils.toCharArray(str);
        for (end = str.length(); end > start && StringUtils.isCutCharOrBlank(chars[end - 1], cutChar); --end) {
        }
        if (start == end) {
            return "";
        }
        if (end < str.length()) {
            return str.substring(start, end);
        }
        return str;
    }

    private static boolean isCutCharOrBlank(char c, char cutChar) {
        return c == cutChar || Character.isWhitespace(c);
    }

    public static String join(char c, char separator, int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0, (String)"n\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return String.valueOf(c);
        }
        char[] chars = new char[2 * n - 1];
        chars[0] = c;
        int i = 1;
        while (i < chars.length) {
            chars[i++] = separator;
            chars[i++] = c;
        }
        return new String(chars);
    }

    public static String join2(char c, char separator, int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0, (String)"n\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return String.valueOf(c);
        }
        char[] chars = new char[3 * n - 2];
        chars[0] = c;
        int i = 1;
        while (i < chars.length) {
            chars[i++] = separator;
            chars[i++] = 32;
            chars[i++] = c;
        }
        return new String(chars);
    }

    public static char[] toCharArray(@NonNull CharSequence str) {
        Assert.notNull((Object)str, (String)"'str' must not be null");
        return STRING_SERVICE.toCharArray(str);
    }

    @NonNull
    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            return "\"" + obj + "\"";
        }
        if (obj instanceof Character) {
            return "'" + obj + "'";
        }
        if (obj instanceof Long) {
            return obj + "L";
        }
        if (obj instanceof Date) {
            return DateUtils.toString((Date)obj);
        }
        if (obj instanceof Enum) {
            return obj.getClass().getSimpleName() + "." + ((Enum)obj).name();
        }
        if (obj instanceof Class) {
            return ReflectionUtils.classToString((Class)obj);
        }
        if (obj instanceof Field) {
            return ReflectionUtils.fieldToString((Field)obj);
        }
        if (obj instanceof Method) {
            return ReflectionUtils.methodToString((Method)obj);
        }
        if (obj instanceof Annotation) {
            return ReflectionUtils.annotationToString((Annotation)obj);
        }
        if (obj instanceof Collection) {
            return CollectionUtils.toString((Collection)obj);
        }
        if (obj.getClass().isArray()) {
            return ArrayUtils.toString(obj);
        }
        if (obj instanceof Map) {
            return MapUtils.toString((Map)obj);
        }
        if (obj.getClass().getClassLoader() == null) {
            return obj.toString();
        }
        return StringUtils.unknownTypeObjectToString(obj);
    }

    @NonNull
    private static String unknownTypeObjectToString(@NonNull Object obj) {
        return CycleDependencyHandler.wrap(obj, o -> {
            Field[] fields;
            String classSimpleName;
            StringBuilder sb = new StringBuilder(32);
            if (obj.getClass().isAnonymousClass()) {
                classSimpleName = !obj.getClass().getSuperclass().equals(Object.class) ? obj.getClass().getSuperclass().getSimpleName() : obj.getClass().getInterfaces()[0].getSimpleName();
                classSimpleName = classSimpleName + "$";
            } else {
                classSimpleName = obj.getClass().getSimpleName();
            }
            sb.append(classSimpleName).append("(");
            int initialLength = sb.length();
            for (Field field : fields = ReflectionUtils.getAllFields(obj.getClass())) {
                Object fieldValue;
                if (sb.length() > initialLength) {
                    sb.append(", ");
                }
                sb.append(field.getName());
                sb.append("=");
                try {
                    fieldValue = ReflectionUtils.getFieldValue(obj, field);
                }
                catch (RuntimeException ignore) {
                    continue;
                }
                if (fieldValue == obj) {
                    sb.append("(this ").append(fieldValue.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(StringUtils.toString(fieldValue));
            }
            sb.append(")");
            return sb.toString();
        });
    }
}

