/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.json.impls;

import com.google.gson.Gson;
import com.google.gson.internal.;
import com.google.gson.reflect.TypeToken;
import icu.easyj.core.json.IJSONService;
import icu.easyj.core.json.JSONParseException;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@LoadLevel(name="gson", order=30)
@DependsOnClass(value={Gson.class})
class GoogleGsonJSONServiceImpl
implements IJSONService {
    GoogleGsonJSONServiceImpl() {
    }

    @Override
    @NonNull
    public <T> T toBean(@NonNull String text, @NonNull Class<T> targetClazz) throws JSONParseException {
        try {
            return (T)new Gson().fromJson(text, targetClazz);
        }
        catch (Exception e) {
            throw new JSONParseException("JSON\u5b57\u7b26\u4e32\u8f6cBean\u5931\u8d25", e);
        }
    }

    @Override
    @NonNull
    public <T> List<T> toList(@NonNull String text, @NonNull Class<T> targetClazz) throws JSONParseException {
        try {
            TypeToken typeToken = TypeToken.get((Type).Gson.Types.newParameterizedTypeWithOwner(null, List.class, (Type[])new Type[]{targetClazz}));
            return (List)new Gson().fromJson(text, typeToken.getType());
        }
        catch (Exception e) {
            throw new JSONParseException("JSON\u5b57\u7b26\u4e32\u8f6cList\u5931\u8d25", e);
        }
    }

    @Override
    @NonNull
    public String toJSONString(@Nullable Object obj) throws JSONParseException {
        try {
            return new Gson().toJson(obj);
        }
        catch (Exception e) {
            throw new JSONParseException("obj\u8f6cJSON\u5b57\u7b26\u4e32\u5931\u8d25", e);
        }
    }

    @Override
    @NonNull
    public String getName() {
        return "gson";
    }
}

