/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.filter;

import cn.hutool.core.collection.ListUtil;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.web.filter.FilterAdapter;
import icu.easyj.web.filter.FilterExclusion;
import icu.easyj.web.filter.IFilterProperties;
import icu.easyj.web.util.HttpConfigs;
import icu.easyj.web.util.HttpUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public abstract class AbstractFilter<P extends IFilterProperties>
implements FilterAdapter {
    private static final List<String> GLOBAL_EXCLUSIONS_LIST = ListUtil.toList((Object[])"GET:/actuator*,GET:/swagger*,GET:/v2/api-docs,GET:/webjars/*,GET:/csrf,GET:/,*:/error".split(","));
    protected final P filterProperties;
    protected String filterName;
    protected final Map<String, List<String>> exclusions;
    protected final Map<String, Boolean> needDoFilterCaches = new ConcurrentHashMap<String, Boolean>();

    protected AbstractFilter(@NonNull P filterProperties) {
        Assert.notNull(filterProperties, (String)"'filterProperties' must not be null");
        this.filterProperties = filterProperties;
        List<String> exclusionsList = this.filterProperties.getExclusions();
        if (exclusionsList == null) {
            exclusionsList = new ArrayList<String>(GLOBAL_EXCLUSIONS_LIST);
        } else {
            exclusionsList.addAll(GLOBAL_EXCLUSIONS_LIST);
        }
        this.exclusions = FilterExclusion.convert(exclusionsList);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String filterName = filterConfig.getFilterName();
        if (StringUtils.isBlank(filterName)) {
            filterName = this.getClass().getSimpleName();
        }
        this.filterName = filterName;
    }

    @Override
    public void destroy() {
        if (this.exclusions != null) {
            this.exclusions.clear();
        }
        this.needDoFilterCaches.clear();
    }

    public boolean isNeedDoFilter(HttpServletRequest request) {
        if (this.filterProperties.isDisabled()) {
            return false;
        }
        if (HttpUtils.isOptionsRequest(request)) {
            return false;
        }
        if (MapUtils.isEmpty(this.exclusions)) {
            return true;
        }
        String method = request.getMethod();
        String uri = HttpUtils.getNoContextPathUri(request.getRequestURI(), HttpConfigs.getContextPath());
        String cacheKey = method + ":" + uri;
        return MapUtils.computeIfAbsent(this.needDoFilterCaches, cacheKey, key -> {
            List<String> patterns;
            String[] methods;
            for (String m : methods = new String[]{method, "*"}) {
                patterns = this.exclusions.get(m);
                if (CollectionUtils.isEmpty(patterns)) continue;
                for (String pattern : patterns) {
                    if (!PatternMatchUtils.simpleMatch((String)pattern, (String)uri)) continue;
                    return false;
                }
            }
            methods = null;
            patterns = null;
            return true;
        });
    }

    public P getFilterProperties() {
        return this.filterProperties;
    }

    @Nullable
    public String getFilterName() {
        return this.filterName;
    }
}

