/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.service;

import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.core.loader.EnhancedServiceNotFoundException;
import icu.easyj.core.util.MapUtils;
import icu.easyj.db.service.IDbService;
import icu.easyj.db.util.DbUtils;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class DbServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbServiceFactory.class);
    private static final ConcurrentHashMap<DataSource, IDbService> DB_SERVICE_MAP = new ConcurrentHashMap();

    public static IDbService getDbService(@NonNull DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must not be null");
        return MapUtils.computeIfAbsent(DB_SERVICE_MAP, dataSource, ds -> {
            String dbType = DbUtils.getDbType(dataSource);
            Class[] argTypes = new Class[]{DataSource.class};
            Object[] args = new Object[]{dataSource};
            try {
                return EnhancedServiceLoader.load(IDbService.class, dbType, argTypes, args);
            }
            catch (EnhancedServiceNotFoundException e) {
                LOGGER.error("\u672a\u627e\u5230\u6570\u636e\u5e93 '{}' \u7684\u670d\u52a1\uff0c\u8bf7\u4f7f\u7528 `{}` \u7684\u65b9\u5f0f\u81ea\u884c\u5b9e\u73b0\uff0c\u53c2\u7167MySQL\u670d\u52a1\u5b9e\u73b0\u7c7b\uff1aMySqlDbServiceImpl", (Object)dbType, (Object)EnhancedServiceLoader.class.getSimpleName());
                throw new EnhancedServiceNotFoundException("\u672a\u627e\u5230\u6570\u636e\u5e93 '" + dbType + "' \u7684\u670d\u52a1", e);
            }
        });
    }
}

