/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.trace;

import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.core.trace.TraceService;
import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.CollectionUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class TraceUtils {
    static List<TraceService> getInstances() {
        return TraceServiceSingletonHolder.INSTANCE.getInstances();
    }

    private static void execute(Consumer<TraceService> consumer) {
        TraceUtils.getInstances().forEach(consumer);
    }

    public static void put(String key, String value) {
        if (key == null) {
            return;
        }
        TraceUtils.execute(ts -> ts.put(key, value));
    }

    public static void put(Map<String, String> map) {
        if (CollectionUtils.isNotEmpty(map)) {
            TraceUtils.execute(ts -> ts.put(map));
        }
    }

    public static void remove(String key) {
        if (key == null) {
            return;
        }
        TraceUtils.execute(ts -> ts.remove(key));
    }

    public static void remove(String ... keys) {
        if (ArrayUtils.isEmpty(keys)) {
            return;
        }
        TraceUtils.execute(ts -> ts.remove(keys));
    }

    public static void clear() {
        TraceUtils.execute(TraceService::clear);
    }

    private static enum TraceServiceSingletonHolder {
        INSTANCE;

        private final List<TraceService> instances = EnhancedServiceLoader.loadAll(TraceService.class);

        public List<TraceService> getInstances() {
            return TraceServiceSingletonHolder.INSTANCE.instances;
        }
    }
}

