/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.trace.impls;

import brave.Tracer;
import cn.hutool.extra.spring.SpringUtil;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import icu.easyj.core.trace.TraceService;
import icu.easyj.core.trace.impls.ZipkinTraceServiceValidate;

@LoadLevel(name="Zipkin-Tracer", order=2, validators={ZipkinTraceServiceValidate.class})
@DependsOnClass(value={Tracer.class})
public class ZipkinTraceServiceImpl
implements TraceService {
    static Tracer getInstance() {
        return TraceServiceSingletonHolder.INSTANCE.instance;
    }

    @Override
    public void put(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            key = "null";
        }
        ZipkinTraceServiceImpl.getInstance().currentSpan().tag(key, value);
    }

    @Override
    public void remove(String key) {
        if (key == null) {
            return;
        }
        ZipkinTraceServiceImpl.getInstance().currentSpan().tag(key, "");
    }

    @Override
    public void clear() {
    }

    private static enum TraceServiceSingletonHolder {
        INSTANCE;

        private final Tracer instance = (Tracer)SpringUtil.getBean(Tracer.class);

        public Tracer getInstances() {
            return TraceServiceSingletonHolder.INSTANCE.instance;
        }
    }
}

