/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.shortcode.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.shortcode.IShortCodeService;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

@LoadLevel(name="default", order=200)
public class DefaultShortCodeServiceImpl
implements IShortCodeService {
    private static final char[] DEFAULT_CHAR_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    protected final char[] charTable;
    protected final String firstChar;

    public DefaultShortCodeServiceImpl() {
        this(DEFAULT_CHAR_TABLE);
    }

    public DefaultShortCodeServiceImpl(char[] charTable) {
        Assert.isTrue((charTable != null && charTable.length > 2 ? 1 : 0) != 0, (String)"'charTable' must not be null");
        this.charTable = charTable;
        this.firstChar = String.valueOf(charTable[0]);
    }

    @Override
    @NonNull
    public String toCode(@NonNull Long id) {
        Assert.isTrue((id != null && id >= 0L ? 1 : 0) != 0, (String)"ID\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        if (id == 0L) {
            return this.firstChar;
        }
        int charTableLength = this.charTable.length;
        double power = Math.log(id.longValue()) / Math.log(charTableLength);
        int charPos = (int)power + 2;
        char[] buf = new char[charPos];
        while (id > 0L) {
            int index = (int)(id % (long)charTableLength);
            buf[--charPos] = this.charTable[index];
            id = id / (long)charTableLength;
        }
        if (charPos == 0) {
            return new String(buf);
        }
        return new String(buf, charPos, buf.length - charPos);
    }

    @Override
    public long toId(@NonNull String shortCode) {
        Assert.isTrue((boolean)StringUtils.isNotBlank(shortCode), (String)"'shortCode' must not be blank");
        char[] chars = StringUtils.toCharArray(shortCode);
        long id = 0L;
        for (int i = 0; i < chars.length; ++i) {
            int index = 0;
            for (int j = 0; j < this.charTable.length; ++j) {
                if (chars[i] != this.charTable[j]) continue;
                index = j;
                break;
            }
            id = i > 0 ? id * (long)this.charTable.length + (long)index : (long)index;
        }
        return id;
    }
}

