/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.cache304;

import icu.easyj.core.util.DateUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.ThrowableUtils;
import icu.easyj.web.cache304.CacheTimeComputer;
import icu.easyj.web.cache304.config.Cache304Config;
import icu.easyj.web.cache304.config.Cache304ConfigManagerFactory;
import icu.easyj.web.util.HttpUtils;
import java.util.Date;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public abstract class Cache304Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cache304Utils.class);

    @Nullable
    public static Object doCache(HttpServletRequest request, HttpServletResponse response, Cache304Config config, Supplier<Object> callback) {
        Date lastModified;
        if (config == null) {
            return callback.get();
        }
        if (HttpUtils.isNoCacheRequest(request)) {
            return Cache304Utils.doCallbackAndSetCache304Header(callback, response, config, -1L);
        }
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (StringUtils.isEmpty(ifModifiedSince)) {
            return Cache304Utils.doCallbackAndSetCache304Header(callback, response, config, -1L);
        }
        try {
            lastModified = DateUtils.parseAll(ifModifiedSince);
        }
        catch (Exception ex) {
            LOGGER.warn("\u89e3\u6790\u65f6\u95f4\u5b57\u7b26\u4e32\u5931\u8d25\uff0cheader[\"{}\"] = {}, error = {}", new Object[]{"If-Modified-Since", ifModifiedSince, ex.getMessage(), ex});
            return Cache304Utils.doCallbackAndSetCache304Header(callback, response, config, -1L);
        }
        long passedTime = System.currentTimeMillis() - lastModified.getTime();
        long cacheTime = CacheTimeComputer.computeTime(lastModified, config);
        if (passedTime < cacheTime) {
            HttpUtils.setResponseStatus304(response);
            return null;
        }
        try {
            return Cache304Utils.doCallbackAndSetCache304Header(callback, response, config, cacheTime);
        }
        catch (Throwable t) {
            if (config.isUseCacheIfException()) {
                if (LOGGER.isErrorEnabled()) {
                    Throwable th = ThrowableUtils.unwrap(t);
                    LOGGER.error("\u5f53\u524d\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff0c\u4f46\u5141\u8bb8\u5ba2\u6237\u7aef\u7ee7\u7eed\u4f7f\u7528\u7f13\u5b58\uff0c\u8fd4\u56de304\u54cd\u5e94\u72b6\u6001\uff01\u4e0d\u629b\u51fa\u5f02\u5e38\uff0c\u4ec5\u8bb0\u5f55\u5f02\u5e38\u65e5\u5fd7\uff1a", th);
                }
                HttpUtils.setResponseStatus304(response);
                return null;
            }
            throw t;
        }
    }

    public static Object doCache(HttpServletRequest request, HttpServletResponse response, Supplier<Object> callback) {
        Cache304Config config = Cache304ConfigManagerFactory.getInstance().getConfig(request);
        return Cache304Utils.doCache(request, response, config, callback);
    }

    public static void doCache(HttpServletRequest request, HttpServletResponse response, Cache304Config config, Runnable runnable) {
        Cache304Utils.doCache(request, response, config, () -> {
            runnable.run();
            return null;
        });
    }

    public static void doCache(HttpServletRequest request, HttpServletResponse response, Runnable runnable) {
        Cache304Config config = Cache304ConfigManagerFactory.getInstance().getConfig(request);
        Cache304Utils.doCache(request, response, config, runnable);
    }

    private static Object doCallbackAndSetCache304Header(Supplier<Object> callback, HttpServletResponse response, Cache304Config config, long cacheTime) {
        long runSeconds;
        long cacheSeconds = cacheTime > 0L ? cacheTime / 1000L : CacheTimeComputer.computeTime(new Date(), config) / 1000L;
        long startTime = System.nanoTime();
        Object result = callback.get();
        if (config.getCacheDays() > 0 && (runSeconds = (System.nanoTime() - startTime) / 1000000000L) > 0L && (cacheSeconds -= runSeconds) <= 0L) {
            return result;
        }
        Date now = new Date();
        response.addDateHeader("Last-Modified", now.getTime());
        if (config.isUseMaxAge()) {
            if (config.getLimitMaxAge() > 0L && cacheSeconds > config.getLimitMaxAge()) {
                cacheSeconds = config.getLimitMaxAge();
            }
            response.setDateHeader("Expires", new Date(now.getTime() + cacheSeconds * 1000L).getTime());
            response.addHeader("Cache-Control", "max-age=" + ++cacheSeconds);
        }
        return result;
    }
}

