/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.dialect;

import icu.easyj.db.dialect.IDbDialect;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class DbDialectAdapter
implements IDbDialect {
    @NonNull
    protected final IDbDialect dbDialect;

    public DbDialectAdapter(Supplier<IDbDialect> dbDialectSupplier) {
        this(dbDialectSupplier.get());
    }

    public DbDialectAdapter(IDbDialect dbDialect) {
        Assert.notNull((Object)dbDialect, (String)"'dbDialect' must not be null");
        this.dbDialect = dbDialect;
    }

    @Override
    public String getVersionSql() {
        return this.dbDialect.getVersionSql();
    }

    @Override
    public String getTimeSql() {
        return this.dbDialect.getTimeSql();
    }

    @Override
    public String getSeqCurrValSql(String seqName) {
        return this.dbDialect.getSeqCurrValSql(seqName);
    }

    @Override
    public String getSeqNextValSql(String seqName) {
        return this.dbDialect.getSeqNextValSql(seqName);
    }

    @Override
    public String getSeqSetValSql(String seqName, long newVal) {
        return this.dbDialect.getSeqSetValSql(seqName, newVal);
    }

    @Override
    @NonNull
    public String getDbType() {
        return this.dbDialect.getDbType();
    }
}

